package com.owl.appl7;

import java.io.*;
import java.net.*;
import java.net.ProtocolException;
import java.security.*;
import java.security.cert.*;
import java.util.*;

import javax.net.ssl.*;

import org.apache.http.*;
import org.apache.http.client.*;
import org.apache.http.client.entity.*;
import org.apache.http.client.methods.*;
import org.apache.http.conn.params.*;
import org.apache.http.entity.mime.*;
import org.apache.http.entity.mime.content.*;
import org.apache.http.params.*;
import org.apache.http.util.*;

import android.app.*;
import android.util.*;
import android.webkit.*;
import android.widget.*;

import com.owl.appl7.cms.*;

public class cmsHTTP {

	public WebView webview;
	public String mimeType = "text/html";
	public String encoding = "UTF-8";
	public int REGISTRATION_TIMEOUT = 10 * 1000;
	public String TAG = "cmsHTTP";
	public Activity act;
	public String noData = "죄송합니다.\n네트웍 장애가 있습니다.\n다시 시도해주세요.";
	public HttpClient httpClient;
	util cmsutil = new util();

	public cmsHTTP() {

	}

	public cmsHTTP(WebView webviewTmp) {
		webview = webviewTmp;
	}

	public String sendGet(String url) {

		String result = null;
		HttpResponse resp;

		if (act != null)
			((owllab) act.getApplication()).startLoading(act);

		HttpGet httpGet = new HttpGet(url);

		// HttpClient httpClient = new DefaultHttpClient();
		httpClient = ((owllab) act.getApplication()).httpClient;
		HttpParams tmpparms = httpClient.getParams();
		HttpConnectionParams.setConnectionTimeout(tmpparms,
				REGISTRATION_TIMEOUT);
		HttpConnectionParams.setSoTimeout(tmpparms, REGISTRATION_TIMEOUT);
		ConnManagerParams.setTimeout(tmpparms, REGISTRATION_TIMEOUT);

		try {
			resp = httpClient.execute(httpGet);
			if (resp.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
				if (Log.isLoggable(TAG, Log.VERBOSE))
					Log.v(TAG, "Successful authentication");
				HttpEntity respEntity = resp.getEntity();
				if (respEntity != null) {
					InputStream instream = respEntity.getContent();
					result = convertStreamToString(instream);
					instream.close();
				}
			} else {
				if (Log.isLoggable(TAG, Log.VERBOSE))
					Log.v(TAG, "Error Process" + resp.getStatusLine());
			}
		} catch (final IOException e) {
			if (Log.isLoggable(TAG, Log.VERBOSE))
				Log.v(TAG, "IOException when getting authtoken", e);
		} finally {
			if (Log.isLoggable(TAG, Log.VERBOSE))
				Log.v(TAG, "completing");
		}

		if (act != null)
			((owllab) act.getApplication()).endLoading();

		if (result == null) {
			Toast.makeText(act, noData, Toast.LENGTH_SHORT).show();
		}

		return result;
	}

	// ArrayList<NameValuePair> httpParams = new ArrayList<NameValuePair>();
	// httpParams.add(new BasicNameValuePair("a", "한글 "));
	// httpParams.add(new BasicNameValuePair("b", "아울컴 OWLCOM"));

	public String sendPostOnly(String url, ArrayList<NameValuePair> params) {

		String result = null;
		HttpResponse resp;
		HttpEntity entity = null;
		try {
			entity = new UrlEncodedFormEntity(params, encoding);
		} catch (final UnsupportedEncodingException e) {
			throw new AssertionError(e);
		}
		HttpPost httpPost = new HttpPost(url);
		httpPost.addHeader(entity.getContentType());
		httpPost.setEntity(entity);

		Log.v(TAG, entity.getContentType().toString());

		// HttpClient httpClient = new DefaultHttpClient();
		httpClient = ((owllab) act.getApplication()).httpClient;
		HttpParams tmpparms = httpClient.getParams();
		HttpConnectionParams.setConnectionTimeout(tmpparms,
				REGISTRATION_TIMEOUT);
		HttpConnectionParams.setSoTimeout(tmpparms, REGISTRATION_TIMEOUT);
		ConnManagerParams.setTimeout(tmpparms, REGISTRATION_TIMEOUT);

		try {
			resp = httpClient.execute(httpPost);
			if (resp.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
				if (Log.isLoggable(TAG, Log.VERBOSE))
					Log.v(TAG, "Successful authentication");
				HttpEntity respEntity = resp.getEntity();
				if (respEntity != null) {
					InputStream instream = respEntity.getContent();
					result = convertStreamToString(instream);
					instream.close();
				}
			} else {
				if (Log.isLoggable(TAG, Log.VERBOSE))
					Log.v(TAG, "Error Process" + resp.getStatusLine());
			}
		} catch (final IOException e) {
			if (Log.isLoggable(TAG, Log.VERBOSE))
				Log.e(TAG, "IOException when getting authtoken", e);
		} catch (Exception e1) {
			Log.e(TAG, e1.toString());
		} finally {
			if (Log.isLoggable(TAG, Log.VERBOSE))
				Log.e(TAG, "completing");
		}

		if (result == null) {
			Toast.makeText(act, noData, Toast.LENGTH_SHORT).show();
		}
		return result;
	}

	public String sendPost(String url, ArrayList<NameValuePair> params) {
		String result = null;
		if (act != null)
			((owllab) act.getApplication()).startLoading(act);

		if (url.indexOf("/user_proc.php") >= 0
				|| url.indexOf("/login_proc.php") >= 0
				|| url.indexOf("/agreement.php") >= 0) {
			url = cmsutil.str_replace_i("http://", "https://", url);
		}
		// url = cmsutil.str_replace_i("http://", "https://", url);
		if (url.indexOf("https://") >= 0) {
			result = https(url, params);
		} else {
			result = sendPostOnly(url, params);
		}

		if (act != null)
			((owllab) act.getApplication()).endLoading();
		return result;
	}

	public void getPost(String url, ArrayList<NameValuePair> params) {

		final String furl = url;
		final ArrayList<NameValuePair> fparams = params;
		Thread t = new Thread() {
			public void run() {
				try {
					String result = sendPostOnly(furl, fparams);

					webview.getSettings().setJavaScriptEnabled(true);
					webview.getSettings()
							.setJavaScriptCanOpenWindowsAutomatically(true);
					webview.getSettings().setPluginsEnabled(true);
//					webview.getSettings().setPluginState(
//							WebSettings.PluginState.ON_DEMAND);
					webview.getSettings().setSupportMultipleWindows(true);
					webview.getSettings().setSupportZoom(true);
					webview.getSettings().setBuiltInZoomControls(true);
					webview.getSettings().setBlockNetworkImage(false);
					webview.getSettings().setLoadsImagesAutomatically(true);
					webview.getSettings().setUseWideViewPort(true);
					webview.getSettings().setCacheMode(
							WebSettings.LOAD_NO_CACHE);
					webview.setWebChromeClient(new WebChromeClient());
					webview.clearCache(true);

					String baseUrl = "http://www.owllab.com/android/";
					// String baseUrl = "about:none";
					webview.loadDataWithBaseURL(baseUrl, result, mimeType,
							encoding, baseUrl);
					// webview.loadData(result, mimeType, encoding);

				} catch (Exception e) {
					Log.d("::Exception::", e.toString());
				}
			}
		};

		t.start();
	}

	public String convertStreamToString(InputStream is) {

		StringBuilder sb = new StringBuilder();
		String line = null;
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					is, encoding), 8);
			while ((line = reader.readLine()) != null) {
				sb.append(line + "\n");
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return sb.toString();
	}

	public void postFile(String url, String filename) throws ClientProtocolException, IOException {
		// HttpClient httpClient = new DefaultHttpClient();
		httpClient = ((owllab) act.getApplication()).httpClient;
		httpClient.getParams().setParameter(
				CoreProtocolPNames.PROTOCOL_VERSION, HttpVersion.HTTP_1_1);

		HttpPost httppost = new HttpPost(url);
		File file = new File(filename);

		MultipartEntity mpEntity = new MultipartEntity();
		ContentBody cbFile = new FileBody(file, "image/jpeg");
		mpEntity.addPart("userfile", cbFile);

		httppost.setEntity(mpEntity);
		System.out.println("executing request " + httppost.getRequestLine());
		HttpResponse response = httpClient.execute(httppost);
		HttpEntity resEntity = response.getEntity();

		if (resEntity != null) {
			System.out.println(EntityUtils.toString(resEntity));
		}
		if (resEntity != null) {
			resEntity.consumeContent();
		}

		// httpClient.getConnectionManager().shutdown();
	}

	private String cookies = null;
	public HttpsURLConnection con;

	public String https(String url, ArrayList<NameValuePair> querys) {

		String result = null;
		String query = "";

		String HTTPS = url;

		if (querys != null) {
			try {
				int c = 0;
				for (int i = 0; i < querys.size(); i++) {
					NameValuePair NVP = querys.get(i);
					if (NVP != null) {
						if (c > 0)
							query += "&";
						c++;
						String tmpName = NVP.getName();
						if (tmpName == null)
							tmpName = "";
						String tmpValue = NVP.getValue();
						if (tmpValue == null)
							tmpValue = "";
						query += URLEncoder.encode(tmpName, encoding);
						query += "=";
						query += URLEncoder.encode(tmpValue, encoding);

					}
				}
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		Log.v(TAG, url);
		Log.v(TAG, HTTPS);
		Log.v(TAG, query);

		try {
			System.setProperty("http.keepAlive", "true");
			SSLContext sc = SSLContext.getInstance("TLS");
			sc.init(null, new TrustManager[] { new TrivialTrustManager() },
					new SecureRandom());

			HttpsURLConnection
					.setDefaultSSLSocketFactory(sc.getSocketFactory());
			HttpsURLConnection
					.setDefaultHostnameVerifier(new PassiveHostnameVerifier());

			URL theURL = new URL(HTTPS);
			con = (HttpsURLConnection) theURL.openConnection();
			con.setConnectTimeout(REGISTRATION_TIMEOUT);
			con.setReadTimeout(REGISTRATION_TIMEOUT);
			con.setRequestProperty("Content-Length", Integer.toString(query
					.getBytes().length));
			con.setRequestProperty("Connection", "Keep-Alive");
			con.setRequestMethod("POST");
			con.setRequestProperty("Host", theURL.getHost());
			con.setRequestProperty("Content-Type",
					"application/x-www-form-urlencoded");
			if (cookies != null) {
				con.setRequestProperty("Cookie", cookies);
			}
			con.setDoOutput(true);
			con.setDoInput(true);
			con.setUseCaches(false);
			con.connect();

			DataOutputStream ostream = null;
			ostream = new DataOutputStream(con.getOutputStream());
			ostream.writeBytes(query);
			ostream.flush();
			ostream.close();

			InputStream instream = con.getInputStream();
			instream = con.getInputStream();

			if (con.getResponseCode() == HttpsURLConnection.HTTP_OK) {
				// Read the cookies
				String cookiesTmp = readCookies(con);
				if (cookiesTmp != null) {
					cookies = cookiesTmp;
				}
				result = convertStreamToString(instream);
				Log.v(TAG, "cookies:" + cookies);
			}
			instream.close();
			con.disconnect();

		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (ProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			Log.e(TAG, HTTPS);
			Log.e(TAG, e.toString());
		} finally {
			if (con != null) {
				con.disconnect();
			}
		}
		return result;
	}

	public class TrivialTrustManager implements X509TrustManager {
		@Override
		public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
		}

		@Override
		public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
		}

		@Override
		public X509Certificate[] getAcceptedIssuers() {
			// return new X509Certificate[0];
			return null;
		}
	}

	public class PassiveHostnameVerifier implements HostnameVerifier {
		@Override
		public boolean verify(String hostname, SSLSession session) {
			return true;
		}
	}

	String HTTP_HEADER_SET_COOKIE = "set-cookie";

	protected String readCookies(HttpsURLConnection con) {
		StringBuilder cookieBuffer = null;
		String cookieField = null;
		String headerName = null;

		for (int i = 1; (headerName = con.getHeaderFieldKey(i)) != null; i++) {
			if (headerName.toLowerCase().equals(HTTP_HEADER_SET_COOKIE)) {
				cookieField = con.getHeaderField(i);
				cookieField = cookieField
						.substring(0, cookieField.indexOf(";"));

				if (cookieBuffer != null) {
					cookieBuffer.append("; ");
				} else {
					cookieBuffer = new StringBuilder();
				}
				cookieBuffer.append(cookieField);
			}
		}

		if (cookieBuffer != null) {
			return cookieBuffer.toString();
		} else {
			return null;
		}
	}
}