
#import "noticeParseOperation.h"
#import "notice.h"
#import "noticeInfo.h"

static NSString *listField1  = @"rowid";
static NSString *listField2  = @"subject";
static NSString *listField3  = @"reg_date";
static NSString *listField4  = @"content";
static NSString *kEntryStr  = @"data";
static NSString *infoTag  = @"info";
static NSString *infoField1  = @"totpage";
static NSString *infoField2  = @"startpage";
static NSString *infoField3  = @"totrec";
static NSString *infoField4  = @"page";
static NSString *infoField5  = @"ipp";
static NSString *infoField6  = @"ten";

@interface noticeParseOperation ()
@property (nonatomic, assign) id <noticeParseOperationDelegate> delegate;
@property (nonatomic, retain) NSData *dataToParse;
@property (nonatomic, retain) NSMutableArray *workingArray;
@property (nonatomic, retain) notice *workingEntry;
@property (nonatomic, retain) NSMutableString *workingPropertyString;
@property (nonatomic, retain) NSArray *elementsToParse;
@property (nonatomic, assign) BOOL storingCharacterData;

@property (nonatomic, retain) NSMutableArray *infoArray;
@property (nonatomic, retain) noticeInfo *infoEntry;
@property (nonatomic, retain) NSArray *infoToParse;

@end

@implementation noticeParseOperation

@synthesize delegate, dataToParse;
@synthesize workingArray, workingEntry, workingPropertyString;
@synthesize elementsToParse, storingCharacterData; 
@synthesize infoArray, infoToParse, infoEntry;

- (id)initWithData:(NSData *)data delegate:(id <noticeParseOperationDelegate>)theDelegate {
    self = [super init];
    if (self != nil) {
        self.dataToParse = data;
        self.delegate = theDelegate;
        self.elementsToParse = [NSArray arrayWithObjects:listField1, listField2, listField3, listField4, nil];
		self.infoToParse = [NSArray arrayWithObjects:infoField1, infoField2, infoField3, infoField4, infoField5, infoField5, nil];
    }
    return self;
}

- (void)dealloc {
    [dataToParse release];
    [workingEntry release];
    [workingPropertyString release];
    [workingArray release];
	
	[infoArray release];
	[infoEntry release];
	
	/*Leak Test ----------------------------*/
	[elementsToParse release];
	[infoToParse release];
	 
    [super dealloc];
}

- (void)main {
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	self.infoArray = [NSMutableArray array];
	self.workingArray = [NSMutableArray array];
    self.workingPropertyString = [NSMutableString string];
    NSXMLParser *parser = [[NSXMLParser alloc] initWithData:dataToParse];
	[parser setDelegate:self];
    [parser parse];
	
	if (![self isCancelled]) {
        [self.delegate didFinishParsing:self.workingArray withInfo:self.infoArray];
    }
    
    self.infoArray = nil;
	self.workingArray = nil;
    self.workingPropertyString = nil;
    self.dataToParse = nil;
	
    [parser release];	
	[pool release];
}


#pragma mark -
#pragma mark Parser processing

- (void)parser:(NSXMLParser *)parser didStartElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName attributes:(NSDictionary *)attributeDict {
    if ([elementName isEqualToString:kEntryStr]) {
        self.workingEntry = [[[notice alloc] init] autorelease];
    }
    storingCharacterData = [elementsToParse containsObject:elementName];
	
	if ([elementName isEqualToString:infoTag]) {
        self.infoEntry = [[[noticeInfo alloc] init] autorelease];
    }
    if (!storingCharacterData) storingCharacterData = [infoToParse containsObject:elementName];
	
}

- (void)parser:(NSXMLParser *)parser didEndElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName {
    if (self.workingEntry) {
        if ([elementName isEqualToString:kEntryStr]) {
            [self.workingArray addObject:self.workingEntry];  
            self.workingEntry = nil;
		} else if (storingCharacterData) {
            NSString *trimmedString = [workingPropertyString stringByTrimmingCharactersInSet: [NSCharacterSet whitespaceAndNewlineCharacterSet]];
            [workingPropertyString setString:@""];
            if ([elementName isEqualToString:listField1]) {
                self.workingEntry.rowid = trimmedString;
            } else if ([elementName isEqualToString:listField2]) {        
                self.workingEntry.subject = trimmedString;
			} else if ([elementName isEqualToString:listField3]) {        
                self.workingEntry.reg_date = trimmedString;
            } else if ([elementName isEqualToString:listField4]) {
                self.workingEntry.content = trimmedString;
            }
        } 
    }
	
	if (self.infoEntry) {
        if ([elementName isEqualToString:infoTag]) {
            [self.infoArray addObject:self.infoEntry];  
            self.infoEntry = nil;
		} else if (storingCharacterData) {
            NSString *trimmedStringInfo = [workingPropertyString stringByTrimmingCharactersInSet: [NSCharacterSet whitespaceAndNewlineCharacterSet]];
            [workingPropertyString setString:@""];
            if ([elementName isEqualToString:infoField1]) {
                self.infoEntry.totpage = trimmedStringInfo;
            } else if ([elementName isEqualToString:infoField2]) {        
                self.infoEntry.startpage = trimmedStringInfo;
			} else if ([elementName isEqualToString:infoField3]) {        
                self.infoEntry.totrec = trimmedStringInfo;
            } else if ([elementName isEqualToString:infoField4]) {
                self.infoEntry.page = trimmedStringInfo;
			} else if ([elementName isEqualToString:infoField5]) {
                self.infoEntry.ipp = trimmedStringInfo;
			} else if ([elementName isEqualToString:infoField6]) {
                self.infoEntry.ten = trimmedStringInfo;
            }
        }
    }
    
}

- (void)parser:(NSXMLParser *)parser foundCharacters:(NSString *)string {
    if (storingCharacterData) {
        [workingPropertyString appendString:string];
    }
}

- (void)parser:(NSXMLParser *)parser parseErrorOccurred:(NSError *)parseError {
    [delegate parseErrorOccurred:parseError];
}

@end

