
#import "smartWriter.h"
#import "Report.h"


@implementation smartWriter

@synthesize report;
@synthesize myInfo;
@synthesize delegate;

#pragma mark -
#pragma mark View Life Cycle

/*
 - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
 self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
 if (self) {
 // Custom initialization.
 }
 return self;
 }
 */

- (void)viewDidLoad {
    [super viewDidLoad];
	myInfo = [[NSMutableDictionary alloc] init];
	[self getCookies];
    
	inputWriter.text = [[myInfo objectForKey:@"suserdb.alias"] stringByReplacingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
	inputUserid.text = [myInfo objectForKey:@"suserdb.userid"];
	self.navigationItem.title = @"Write a Report";
    
    UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"Cancel" style:UIBarButtonItemStyleBordered target:self action:@selector(cancel)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;
    [cancelButtonItem release];
    
    UIBarButtonItem *saveButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"Save" style:UIBarButtonItemStyleDone target:self action:@selector(save)];
    self.navigationItem.rightBarButtonItem = saveButtonItem;
    [saveButtonItem release];
	
	[inputSubject becomeFirstResponder];
}

- (void) viewWillAppear:(BOOL)animated {
	[super viewWillAppear:animated];
	
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionFlipFromLeft forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}


#pragma mark -
#pragma mark Memory Managements

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)viewDidUnload {
    [inputSubject release];
    inputSubject = nil;
    [inputWriter release];
    inputWriter = nil;
    [inputUserid release];
    inputUserid = nil;
    [super viewDidUnload];
}


- (void)dealloc {
    [inputSubject release];
    [inputWriter release];
    [inputUserid release];
	[report release];    
	[myInfo release];
    [super dealloc];
}

#pragma mark -
#pragma mark UITextFeild Delegate

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	if (textField == inputSubject) {
		[inputSubject resignFirstResponder];
	}
	return YES;
}

#pragma mark -
#pragma mark CoreData

- (void)save {
    report.subject = inputSubject.text;
    report.reg_id = inputUserid.text;
    report.writer = inputWriter.text;
    report.reg_date = [NSDate date];
	
	NSError *error = nil;
	if (![report.managedObjectContext save:&error]) {
		NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
		abort();
	}
    
	[self.delegate viewController:self didWrite:report];
}

- (void)cancel {
	[report.managedObjectContext deleteObject:report];
    
	NSError *error = nil;
	if (![report.managedObjectContext save:&error]) {
		NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
		abort();
	}	
    
	[self.delegate viewController:self didWrite:nil];
}

#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

@end
