
#import "OWLXMLParser.h"

@implementation OWLXMLParser

@synthesize infoTag, dataTag, infoFields, dataFields;
@synthesize resultDic;
@synthesize delegate, dataToParse;
@synthesize workingPropertyString;
@synthesize storingCharacterData; 

- (id)initWithData:(NSData *)data delegate:(id <OWLXMLParserDelegate>)theDelegate xmlInfo:(NSMutableDictionary *)xmlDic {
    self = [super init];
    if (self != nil) {
        self.dataToParse = data;
        self.delegate = theDelegate;
		
		self.resultDic = [[NSMutableDictionary alloc] init];
		
		self.infoTag = [xmlDic valueForKey:@"infoTag"];
		self.dataTag = [xmlDic valueForKey:@"dataTag"];
		self.infoFields = [xmlDic valueForKey:@"infoFields"];
		self.dataFields = [xmlDic valueForKey:@"dataFields"];
		
		self.workingPropertyString = [NSMutableString string];
		
    }
    return self;
}

- (void)startParse {
	
	[resultDic removeAllObjects];
	[self.resultDic setObject:[[[NSMutableDictionary alloc] init] autorelease] forKey:@"info"];
	[self.resultDic setObject:[[[NSMutableArray alloc] init] autorelease] forKey:@"data"];
	
    NSXMLParser *parser = [[NSXMLParser alloc] initWithData:dataToParse];
	[parser setDelegate:self];
    [parser parse];
	[self.delegate didFinishParsing:[resultDic autorelease]];
	
    self.workingPropertyString = nil;
    self.dataToParse = nil;	
    [parser release];	
}



- (void)dealloc {
	
	[infoTag release];
	[dataTag release];
	[infoFields release];
	[dataFields release];
	[resultDic release];
    [dataToParse release];
    [workingPropertyString release];
	
    [super dealloc];
}


#pragma mark -
#pragma mark Parser processing

- (void)parser:(NSXMLParser *)parser didStartElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName attributes:(NSDictionary *)attributeDict {
    if ([elementName isEqualToString:dataTag]) {
        [[self.resultDic objectForKey:@"data"] addObject:[[[NSMutableDictionary alloc] init] autorelease]];
    }
    storingCharacterData = [dataFields containsObject:elementName];
	
	if ([elementName isEqualToString:infoTag]) {
		[[self.resultDic objectForKey:@"info"] removeAllObjects];
    }
    if (!storingCharacterData) storingCharacterData = [infoFields containsObject:elementName];
	
}

- (void)parser:(NSXMLParser *)parser didEndElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName {
	
	NSString *trimmedString = [workingPropertyString stringByTrimmingCharactersInSet: [NSCharacterSet whitespaceAndNewlineCharacterSet]];
	[workingPropertyString setString:@""];
	if ([infoFields containsObject:elementName]) {
		[[self.resultDic objectForKey:@"info"] setObject:trimmedString forKey:elementName];
	} else if ([dataFields containsObject:elementName]) {
		[[[self.resultDic objectForKey:@"data"] lastObject] setObject:trimmedString forKey:elementName];
	} else {
		[trimmedString release];
	}
	
	
}

- (void)parser:(NSXMLParser *)parser foundCharacters:(NSString *)string {
    if (storingCharacterData) {
        [workingPropertyString appendString:string];
    }
}

- (void)parser:(NSXMLParser *)parser parseErrorOccurred:(NSError *)parseError {
    [delegate parseErrorOccurred:parseError];
}

@end

