
#import "smartWriter.h"
#import "OWLXMLParser.h"

@class Report;
@class ReportTableViewCell;

@interface myReports : UITableViewController <NSFetchedResultsControllerDelegate, UIActionSheetDelegate, smartWriteDelegate, OWLXMLParserDelegate> {
@private
	NSManagedObjectContext *managedObjectContext;	
    NSFetchedResultsController *fetchedResultsController;
    NSFetchedResultsController *reportTypeFRC;
    NSMutableDictionary *myInfo;
    int urlNum;
    
    //  NSString *queryString;
    //	NSData *queryData;
    //	NSURLConnection *urlCon;
	NSMutableData *rawData;
	NSMutableDictionary *dicData;
}

@property (nonatomic, retain) NSManagedObjectContext *managedObjectContext;
@property (nonatomic, retain) NSFetchedResultsController *fetchedResultsController;
@property (nonatomic, retain) NSFetchedResultsController *reportTypeFRC;
@property (nonatomic, retain) NSMutableDictionary *myInfo;

//@property (nonatomic, retain) NSString *queryString;
//@property (nonatomic, retain) NSData *queryData;
//@property (nonatomic, retain) NSURLConnection *urlCon;
@property (nonatomic, retain) NSMutableData *rawData;
@property (nonatomic, retain) NSMutableDictionary *dicData;

- (void) loadReports;
- (void)configureCell:(ReportTableViewCell *)cell atIndexPath:(NSIndexPath *)indexPath;
- (void) addActionBtn;
- (IBAction) contextMenu:(id)sender;
- (void) selectTabBar:(NSString *) title;
- (void) showDetail:(Report *) report;
- (void) EditTable;
- (void) getCookies;

- (void) getURLReportType;
- (void) getURLMyReports;
- (void) handleError:(NSError *)error;
- (void) initMyReports:(NSMutableDictionary *) data;
- (void) initReportTypeData:(NSMutableDictionary *) data;
- (NSDate *) getDateTimeFromString:(NSString *) dateString;
- (NSNumber *) string2Number:(NSString *) str;

@end
