
#import "myReports.h"
#import "Report.h"
#import "ReportType.h"
#import "smartView.h"
#import "smartWriter.h"
#import "ReportTableViewCell.h"

#pragma mark -
#pragma mark making the SSL Allowed.. 
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end

@implementation myReports

@synthesize managedObjectContext, fetchedResultsController;
@synthesize myInfo;
@synthesize reportTypeFRC;
//@synthesize queryString, queryData, urlCon;
@synthesize rawData, dicData;
@synthesize deleteid;

#pragma mark -
#pragma mark Fetched results controller

- (NSFetchedResultsController *)fetchedResultsController {
    
    if (fetchedResultsController == nil) {
		// NSFetchRequest : SQL Object
        NSFetchRequest *fetchRequest = [[NSFetchRequest alloc] init];
        
		// NSEntityDescription : Table
        NSEntityDescription *entity = [NSEntityDescription entityForName:@"Report" inManagedObjectContext:managedObjectContext];
        [fetchRequest setEntity:entity];
        
        // NSPredicate : where 
        NSPredicate *pred = [NSPredicate predicateWithFormat:@"reg_id=%@",[myInfo objectForKey:@"suserdb.userid"]];
        NSLog(@"NSPredicate : %@", pred);
        [fetchRequest setPredicate:pred];
        
        // NSSortDescriptor : order by ~
        NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"reg_date" ascending:NO];
        NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
        [fetchRequest setSortDescriptors:sortDescriptors];
        
        // NSFetchedResultsController : Results
        NSFetchedResultsController *aFetchedResultsController = [[NSFetchedResultsController alloc] initWithFetchRequest:fetchRequest managedObjectContext:managedObjectContext sectionNameKeyPath:nil cacheName:@"RootMy"];
        [NSFetchedResultsController deleteCacheWithName:nil];
        aFetchedResultsController.delegate = self;
        self.fetchedResultsController = aFetchedResultsController;
        
        [aFetchedResultsController release];
        [fetchRequest release];
        [sortDescriptor release];
        [sortDescriptors release];
    }
	
	return fetchedResultsController;
}    


#pragma mark -
#pragma mark NSFetchedResultsController Delegate

- (void)controllerWillChangeContent:(NSFetchedResultsController *)controller {
	[self.tableView beginUpdates];
}


- (void)controller:(NSFetchedResultsController *)controller didChangeObject:(id)anObject atIndexPath:(NSIndexPath *)indexPath forChangeType:(NSFetchedResultsChangeType)type newIndexPath:(NSIndexPath *)newIndexPath {
	UITableView *tableView = self.tableView;
	
	switch(type) {
		case NSFetchedResultsChangeInsert:
			[tableView insertRowsAtIndexPaths:[NSArray arrayWithObject:newIndexPath] withRowAnimation:UITableViewRowAnimationFade];
			break;
			
		case NSFetchedResultsChangeDelete:
			[tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
			break;
			
		case NSFetchedResultsChangeUpdate:
			[self configureCell:(ReportTableViewCell *)[tableView cellForRowAtIndexPath:indexPath] atIndexPath:indexPath];
			break;
			
		case NSFetchedResultsChangeMove:
			[tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            [tableView insertRowsAtIndexPaths:[NSArray arrayWithObject:newIndexPath] withRowAnimation:UITableViewRowAnimationFade];
            break;
	}
}


- (void)controller:(NSFetchedResultsController *)controller didChangeSection:(id <NSFetchedResultsSectionInfo>)sectionInfo atIndex:(NSUInteger)sectionIndex forChangeType:(NSFetchedResultsChangeType)type {
	switch(type) {
		case NSFetchedResultsChangeInsert:
			[self.tableView insertSections:[NSIndexSet indexSetWithIndex:sectionIndex] withRowAnimation:UITableViewRowAnimationFade];
			break;
			
		case NSFetchedResultsChangeDelete:
			[self.tableView deleteSections:[NSIndexSet indexSetWithIndex:sectionIndex] withRowAnimation:UITableViewRowAnimationFade];
			break;
	}
}


- (void)controllerDidChangeContent:(NSFetchedResultsController *)controller {
	[self.tableView endUpdates];
}


- (void) loadReports {
    NSLog(@"%s [%d] fetchedResultsController start loading.....",__PRETTY_FUNCTION__, __LINE__);
    //    fetchedResultsController = nil;
    NSError *error = nil;
	if (![[self fetchedResultsController] performFetch:&error]) {
		NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
		abort();
	}
}


#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	NSInteger count = [[fetchedResultsController sections] count];
	if (count == 0) {
		count = 1;
	}
    return count;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSInteger numberOfRows = 0;
    if ([[fetchedResultsController sections] count] > 0) {
        id <NSFetchedResultsSectionInfo> sectionInfo = [[fetchedResultsController sections] objectAtIndex:section];
        numberOfRows = [sectionInfo numberOfObjects];
    }
    return numberOfRows;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    ReportTableViewCell *cell = (ReportTableViewCell *)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[ReportTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
		cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
	[self configureCell:cell atIndexPath:indexPath];
    
    return cell;
}

- (void)configureCell:(ReportTableViewCell *)cell atIndexPath:(NSIndexPath *)indexPath {
	Report *report = (Report *)[fetchedResultsController objectAtIndexPath:indexPath];
    cell.type = @"my";
    cell.report = report;
}


#pragma mark -
#pragma mark Table view delegate

- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        
        Report *report = (Report *)[fetchedResultsController objectAtIndexPath:indexPath];
		deleteid = [report.cryptid copy]; 
        [self deleteData];
        
        NSManagedObjectContext *context = managedObjectContext;
		[context deleteObject:[fetchedResultsController objectAtIndexPath:indexPath]];
		NSError *error;
		if (![context save:&error]) {
			NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
			abort();
		}
		
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        
    }   
}


/*
 // Override to support rearranging the table view.
 - (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
 }
 */


/*
 // Override to support conditional rearranging of the table view.
 - (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the item to be re-orderable.
 return YES;
 }
 */


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	Report *report = (Report *)[fetchedResultsController objectAtIndexPath:indexPath];
	[self showDetail:report];
}


#pragma mark - delete a data on server 

- (void) deleteData {
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Alert: Delete!!" message:@"Would you delete the selected report on server too?" delegate:self cancelButtonTitle:@"No" otherButtonTitles:@"Yes" , nil];
    [alert show];
    [alert release];
}

- (void) alertView:(UIAlertView *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
    if ([actionSheet.title isEqualToString:@"Alert: Delete!!"]) {
        if (buttonIndex == 0) {
            
        } else if (buttonIndex == 1) {
            [self deleteURLMyReport:deleteid];
        }
    }
}


#pragma mark -
#pragma mark EditTable 

- (void) EditTable {
	
    if(self.tableView.editing) {
		[super setEditing:NO animated:NO];
		[self.tableView setEditing:NO animated:NO];
		[self.tableView reloadData];
		[self.navigationItem setRightBarButtonItem:[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAction target:self action:@selector(contextMenu:)]];
    } else {
		[super setEditing:YES animated:YES];
		[self.tableView setEditing:YES animated:YES];
		[self.tableView reloadData];
		[self.navigationItem setRightBarButtonItem:[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(EditTable)]];
    }
	
}


#pragma mark -
#pragma mark Context Menu

- (void) addActionBtn {
	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAction  target:self action:@selector(contextMenu:)];
    [self.navigationItem setRightBarButtonItem:addButton];
	[addButton release];
}

- (IBAction) contextMenu:(id)sender {
	UIActionSheet *sheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:nil cancelButtonTitle:nil destructiveButtonTitle:nil otherButtonTitles:nil] autorelease];
    [sheet addButtonWithTitle:@"Download My Reports"];
    [sheet addButtonWithTitle:@"List All Smart Reports"];
	[sheet addButtonWithTitle:@"Write a Report"];
	[sheet addButtonWithTitle:@"Delete Local Reports"];
	[sheet addButtonWithTitle:@"Cancel"];
	sheet.cancelButtonIndex = 4;
	sheet.delegate = self;
	[sheet showInView:self.view];
}

enum ArchiveActionSheetButtons {
    Download,
    GotoSmartReports,
	Add,
	Delete
};

- (void) actionSheet:(UIActionSheet*)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
	switch(buttonIndex) {	
		case Download: {
			[self getURLReportType];
			break;
		}
        case GotoSmartReports: {
			[self selectTabBar:@"Smart Reports"];
			break;
		}
		case Add: { 
			smartWriter *tmpViewController = [[smartWriter alloc] initWithNibName:@"smartWriter" bundle:nil];
			tmpViewController.delegate = self;
			
			Report *newReport = [NSEntityDescription insertNewObjectForEntityForName:@"Report" inManagedObjectContext:managedObjectContext];
			tmpViewController.report = newReport;
			
			UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:tmpViewController];
			[self presentModalViewController:navigationController animated:YES];
			
			[navigationController release];
			[tmpViewController release];
			
			break;
		}
		case Delete: { 
			[self EditTable];
			break;
		}
        default: { 
			break;
		}
	}
}

#pragma mark -
#pragma mark smartWriter Delegate
- (void)viewController:(smartWriter *)ViewController didWrite:(Report *)report {
    if (report) {        
        [self showDetail:report];
    }
    [self dismissModalViewControllerAnimated:YES];
}

- (void) showDetail:(Report *) report {
	smartView *detailViewController = [[smartView alloc] initWithStyle:UITableViewStyleGrouped];
    detailViewController.report = report;
    [self.navigationController pushViewController:detailViewController animated:YES];
    [detailViewController release];	
}

#pragma mark -
#pragma mark Change tabBarController

- (void) selectTabBar:(NSString *) title {
	BOOL found = NO;
	UITabBarController *tabBarCtrl = super.tabBarController;
	NSArray *viewa = tabBarCtrl.viewControllers;
	for (int i=0; i<[viewa count];i++) {
		NSLog(@"%@", [[viewa objectAtIndex:i] nibName]);
		if ([[[viewa objectAtIndex:i] title] isEqualToString:title]) {
			tabBarCtrl.selectedIndex = i;
			found = YES;
			break;
		}
	}
	if (found==NO) {
		tabBarCtrl.selectedIndex = 0;
	}
}

#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

#pragma mark -
#pragma mark NSURLConnection

- (void) getURLReportType {
	
    //실험주소 : http://www.owllab.com/ios/smartreports_type.php
	
    urlNum = 1;
	[dicData release];
	dicData = [[NSMutableDictionary alloc] init];
	
	NSString *url = @"https://www.owllab.com/ios/smartreports_type.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
    
    NSString * queryString = @"";
	NSData * queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
    
	NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:20.0f];
	
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8;" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];
	
    NSURLConnection * theCon = [[NSURLConnection alloc] initWithRequest:urlRequest delegate:self];
    if (theCon!=nil) {
        NSLog(@"%s [%d]: %@", __PRETTY_FUNCTION__, __LINE__, theCon);
    }
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
    //  [url release];
    //	[urlRequest release];
    
}

- (void) getURLMyReports {
	
	//실험주소 : http://www.owllab.com/ios/myreports.php
    
	urlNum = 2;
	[dicData release];
	dicData = [[NSMutableDictionary alloc] init];
	
	NSString *url = @"https://www.owllab.com/ios/myreports.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
    
    NSString * queryString = @"";
	NSData * queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
    
	NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:20.0f];
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8;" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];
	
	//POST////////////////
	
    NSURLConnection *theCon = [[NSURLConnection alloc] initWithRequest:urlRequest delegate:self];
    if (theCon!=nil) {
        NSLog(@"%s [%d]: %@", __PRETTY_FUNCTION__, __LINE__, theCon);
    }
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
    //	[url release];
    //	[urlRequest release];
    
}

- (void) deleteURLMyReport:(NSString *) reportid {
	
	//실험주소 : http://www.owllab.com/ios/myreports_delete.php
    
	urlNum = 3;
	[dicData release];
	dicData = [[NSMutableDictionary alloc] init];
	
	NSString *url = @"https://www.owllab.com/ios/myreports_delete.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
    NSLog(@"%s [%d] reportid: %@", __PRETTY_FUNCTION__, __LINE__, reportid);
    NSString * queryString = [NSString stringWithFormat:@"mode=del&cryptid=%@", [reportid stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
	NSData * queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
    
	NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:20.0f];
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8;" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];

    NSURLConnection *theCon = [[NSURLConnection alloc] initWithRequest:urlRequest delegate:self];
    if (theCon!=nil) {
        NSLog(@"%s [%d]: %@", __PRETTY_FUNCTION__, __LINE__, theCon);
    }
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
	self.rawData = [NSMutableData data];
    //Coolkie///////////////////////////
	NSURL *cookieUrl = [NSURL URLWithString:[[response URL] host]];
	NSHTTPURLResponse *urlResponse = (NSHTTPURLResponse *)response;
    NSArray *allCookies = [NSHTTPCookie cookiesWithResponseHeaderFields:[urlResponse allHeaderFields] forURL:cookieUrl];
	NSLog(@"%s [%d]: [allCookies count]: %d", __PRETTY_FUNCTION__, __LINE__, [allCookies count]);
    if ([allCookies count]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] setCookies:allCookies forURL:cookieUrl mainDocumentURL:nil];
	}
	//Coolkie///////////////////////////
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    //Codes for Leak .... 
    [connection release];
    NSURLCache *sharedCache = [[NSURLCache alloc] initWithMemoryCapacity:0 diskCapacity:0 diskPath:nil];
    [NSURLCache setSharedURLCache:sharedCache];
    [sharedCache release];
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    //Codes for Leak .... 
    [connection release];
    NSURLCache *sharedCache = [[NSURLCache alloc] initWithMemoryCapacity:0 diskCapacity:0 diskPath:nil];
    [NSURLCache setSharedURLCache:sharedCache];
    [sharedCache release];
	
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	
	NSMutableDictionary *xmlDic = [[NSMutableDictionary alloc] init];
	[xmlDic setObject:@"info" forKey:@"infoTag"];
	[xmlDic setObject:@"data" forKey:@"dataTag"];
    if (urlNum==1) {
        [xmlDic 
         setObject:[NSArray arrayWithObjects:@"result", @"totrec", @"msg", nil] 
         forKey:@"infoFields"];
        [xmlDic setObject:[NSArray arrayWithObjects:@"name", nil] forKey:@"dataFields"];
	} else if (urlNum==2) {
        [xmlDic 
         setObject:[NSArray arrayWithObjects:@"result", @"totrec", @"msg", nil] 
         forKey:@"infoFields"];
        [xmlDic setObject:[NSArray arrayWithObjects:@"rowid", @"subject", @"writer", @"reg_id", @"reg_date", @"type", @"publish", @"cryptid", @"latitude", @"longitude", @"content", nil] forKey:@"dataFields"];
    } else if (urlNum==3) {
        [xmlDic 
         setObject:[NSArray arrayWithObjects:@"result", @"totrec", @"msg", nil] 
         forKey:@"infoFields"];
        [xmlDic setObject:[NSArray arrayWithObjects:@"rowid", nil] forKey:@"dataFields"];
	}
	OWLXMLParser *parser = [[OWLXMLParser alloc] initWithData:rawData delegate:self xmlInfo:xmlDic];
	[parser startParse];
	[parser release];
	[xmlDic release];
    
	self.rawData = nil;
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];
}


#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSMutableDictionary *) resultDic {
	[self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:resultDic waitUntilDone:NO];
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSMutableDictionary *)loadedDic {
	int result = [[[loadedDic objectForKey:@"info"] objectForKey:@"result"] intValue];
    BOOL alertState = YES;
	if (result == 1) {
        if (urlNum==1) {
            [self initReportTypeData:loadedDic];
        } else if (urlNum==2) {
            [self initMyReports:loadedDic];
        }
        alertState = NO;
        if (urlNum==3) alertState = YES;
	}
    
    if (alertState) {
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"요청결과" message:@"" delegate:self cancelButtonTitle:@"확인" otherButtonTitles:nil];
        alertView.message = [[loadedDic objectForKey:@"info"] objectForKey:@"msg"];
        [alertView show];
        [alertView release];
    }
    
}



#pragma mark -
#pragma mark ReportType Fetched results controller 

- (NSFetchedResultsController *) reportTypeFRC {
    NSLog(@"%s [%d] start ==========:",__PRETTY_FUNCTION__, __LINE__ );
    if (reportTypeFRC == nil) {
		// NSFetchRequest : SQL Object
        NSFetchRequest *fetchRequest = [[NSFetchRequest alloc] init];
        
		// NSEntityDescription : Table
        NSEntityDescription *entity = [NSEntityDescription entityForName:@"ReportType" inManagedObjectContext:managedObjectContext];
        [fetchRequest setEntity:entity];
        
        // NSSortDescriptor : order by ~
        NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"name" ascending:NO];
        NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
        [fetchRequest setSortDescriptors:sortDescriptors];
        
        NSFetchedResultsController *aFetchedResultsController = [[NSFetchedResultsController alloc] initWithFetchRequest:fetchRequest managedObjectContext:managedObjectContext sectionNameKeyPath:nil cacheName:@"Root"];
        [NSFetchedResultsController deleteCacheWithName:nil];
        aFetchedResultsController.delegate = nil;
        self.reportTypeFRC = aFetchedResultsController;
        
        [aFetchedResultsController release];
        [fetchRequest release];
        [sortDescriptor release];
        [sortDescriptors release];
    }
	NSLog(@"%s [%d] end ==========:",__PRETTY_FUNCTION__, __LINE__ );
	return reportTypeFRC;
}


#pragma mark -
#pragma mark NSManagedObjectContext

- (void) initReportTypeData:(NSMutableDictionary *) loadedDic {
    NSLog(@"%s [%d] start ==========:",__PRETTY_FUNCTION__, __LINE__ );
    
    NSError *error = nil;
	if (![[self reportTypeFRC] performFetch:&error]) {
		NSLog(@"%s [%d] Unresolved error %@, %@",__PRETTY_FUNCTION__, __LINE__ , error, [error userInfo]);
		abort();
	}
    
    int totrec = [[[loadedDic objectForKey:@"info"] objectForKey:@"totrec"] intValue];
    NSLog(@"%s [%d] totrec : %d",__PRETTY_FUNCTION__, __LINE__ , totrec);
    
    NSInteger sectionCount = [[reportTypeFRC sections] count];
	if (sectionCount == 0) sectionCount = 1;
    
    BOOL found = NO;
    for (int i=0;i<sectionCount;i++) {
        id <NSFetchedResultsSectionInfo> sectionInfo = [[reportTypeFRC sections] objectAtIndex:i];
        NSInteger numberOfRows = 0;
        numberOfRows = [sectionInfo numberOfObjects];
        for (int j=0;j<numberOfRows;j++) {
            NSIndexPath *indexPath = [NSIndexPath indexPathForRow:j inSection:i];
            NSString *theName = [(ReportType *)[reportTypeFRC objectAtIndexPath:indexPath] name];
            found = NO;
            for (int k=0;k<totrec;k++) {
                NSMutableDictionary *dataTmp = [[[loadedDic objectForKey:@"data"] objectAtIndex:k] copy];
                if ([[dataTmp objectForKey:@"name"] isEqualToString:theName]) {
                    found = YES;
                }
                [dataTmp release];
            }//for k
            
            if (found==NO) {
                [managedObjectContext deleteObject:(ReportType *)[reportTypeFRC objectAtIndexPath:indexPath]];
            }
            
        }//for j
    }//for i
    
    if (![managedObjectContext save:&error]) {
        NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
        abort();
    }
    
    for (int k=0;k<totrec;k++) {
        NSMutableDictionary *dataTmp = [[[loadedDic objectForKey:@"data"] objectAtIndex:k] copy];
        NSLog(@"%s [%d] dataTmp : %@",__PRETTY_FUNCTION__, __LINE__ , dataTmp);
        found = NO;
        for (int i=0;i<sectionCount;i++) {
            id <NSFetchedResultsSectionInfo> sectionInfo = [[reportTypeFRC sections] objectAtIndex:i];
            NSInteger numberOfRows = 0;
            numberOfRows = [sectionInfo numberOfObjects];
            for (int j=0;j<numberOfRows;j++) {
                NSIndexPath *indexPath = [NSIndexPath indexPathForRow:j inSection:i];
                ReportType * tmpReportType = (ReportType *) [reportTypeFRC objectAtIndexPath:indexPath];
                if ([[dataTmp objectForKey:@"name"] isEqualToString:[tmpReportType name]]) {
                    found = YES;
                }
            }//for j
        }//for i
        if (found==NO) {
            ReportType *newReportType = (ReportType *) [NSEntityDescription insertNewObjectForEntityForName:@"ReportType" inManagedObjectContext:managedObjectContext];
            newReportType.name = [NSString stringWithFormat:@"%@", [dataTmp objectForKey:@"name"]];
        }
        [dataTmp release];
    }
    
    error = nil;
    if (![managedObjectContext save:&error]) {
        NSLog(@"%s [%d] Unresolved error %@, %@",__PRETTY_FUNCTION__, __LINE__ , error, [error userInfo]);
        abort();
    }
    
    [self getURLMyReports];
    
}

- (void) initMyReports:(NSMutableDictionary *) loadedDic {
    NSLog(@"%s [%d] start ==========:",__PRETTY_FUNCTION__, __LINE__ );
    
    int totrec = [[[loadedDic objectForKey:@"info"] objectForKey:@"totrec"] intValue];
    NSLog(@"%s [%d] totrec : %d",__PRETTY_FUNCTION__, __LINE__ , totrec);
    
    NSInteger sectionCount = [[fetchedResultsController sections] count];
	if (sectionCount == 0) sectionCount = 1;
    
    BOOL found = NO;
    for (int k=0;k<totrec;k++) {
        NSMutableDictionary *dataTmp = [[[loadedDic objectForKey:@"data"] objectAtIndex:k] copy];
        found = NO;
        for (int i=0;i<sectionCount;i++) {
            id <NSFetchedResultsSectionInfo> sectionInfo = [[fetchedResultsController sections] objectAtIndex:i];
            NSInteger numberOfRows = 0;
            numberOfRows = [sectionInfo numberOfObjects];
            for (int j=0;j<numberOfRows;j++) {
                if ([[NSNumber numberWithInt:[[dataTmp valueForKey:@"rowid"] intValue]] isEqualToNumber:[(Report *) [fetchedResultsController objectAtIndexPath:[NSIndexPath indexPathForRow:j inSection:i]] rowid]]) {
                    found = YES;
                }
                if (found) break;
            }//for j
            if (found) break;
        }//for i
        if (found==NO) {
            Report *newReport = (Report *) [NSEntityDescription insertNewObjectForEntityForName:@"Report" inManagedObjectContext:managedObjectContext];
            
            newReport.rowid = [self string2Number:[dataTmp objectForKey:@"rowid"]];
            newReport.writer = [dataTmp objectForKey:@"writer"];
            newReport.subject = [dataTmp objectForKey:@"subject"];
            newReport.content = [dataTmp objectForKey:@"content"];
            newReport.reg_date = [self getDateTimeFromString:[dataTmp objectForKey:@"reg_date"]];
            newReport.reg_id = [dataTmp objectForKey:@"reg_id"];
            newReport.type = [dataTmp objectForKey:@"type"];
            newReport.publish = [self string2Number:[dataTmp objectForKey:@"publish"]];
            newReport.cryptid = [dataTmp objectForKey:@"cryptid"];
            newReport.latitude = [dataTmp objectForKey:@"latitude"];
            newReport.longitude = [dataTmp objectForKey:@"longitude"];
            
            newReport.listImage = [UIImage imageWithData:[NSData dataWithContentsOfURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?listimageid=%@",[dataTmp objectForKey:@"cryptid"]]]]];
            
            newReport.image = [NSEntityDescription insertNewObjectForEntityForName:@"Image" inManagedObjectContext:managedObjectContext];
            /*
             [newReport.image setValue:[UIImage imageWithData:[NSData dataWithContentsOfURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?imageid=%@",[dataTmp objectForKey:@"cryptid"]]]]] forKey:@"image"];
             
             NSURL * movieUrl = [NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?movieid=%@",[dataTmp objectForKey:@"cryptid"]]];
             NSData *movieData = [NSData dataWithContentsOfURL:movieUrl];
             if ([movieData length]>0) {
             NSString *moviePath = [NSString stringWithFormat:@"%@/%@.mov", NSTemporaryDirectory(), newReport.rowid];
             [movieData writeToFile:moviePath atomically:NO];
             UISaveVideoAtPathToSavedPhotosAlbum (moviePath, self, @selector(movie:didFinishSavingWithError: contextInfo:), nil);
             newReport.movie = moviePath;
             }
             */
            NSLog(@"%s [%d] Downloaded %@. %@",__PRETTY_FUNCTION__, __LINE__ , newReport.rowid, newReport.subject);
            
        }
        NSError *error = nil;
        if (![managedObjectContext save:&error]) {
            NSLog(@"%s [%d] Unresolved error %@, %@",__PRETTY_FUNCTION__, __LINE__ , error, [error userInfo]);
            abort();
        }
        [dataTmp release];
    } 
    
}

- (void) movie:(NSString *) moviePath didFinishSavingWithError:(NSError *) error contextInfo:(void *) contextInfo {
    if (error==nil) {
        NSLog(@"%s [%d] Movie File Saved: %@",__PRETTY_FUNCTION__, __LINE__, moviePath);
    } else {
        NSLog(@"%s [%d] Movie File Saving Error: %@",__PRETTY_FUNCTION__, __LINE__, error);
    }
}


#pragma mark -
#pragma mark Utils 

- (NSDate *) getDateTimeFromString:(NSString *) dateString {
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
	NSDate *theDate = [dateFormatter dateFromString:dateString];
	[dateFormatter release];
	return theDate;
}

- (NSNumber *) string2Number:(NSString *) str {
    NSNumberFormatter *f = [[NSNumberFormatter alloc] init];
    [f setNumberStyle:NSNumberFormatterDecimalStyle];
    NSNumber *theNumber = [f numberFromString:str];
    [f release];
	return theNumber;
}


#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    
    myInfo = [[NSMutableDictionary alloc] init];
	[self getCookies];
	
    NSError *error = nil;
	if (![[self reportTypeFRC] performFetch:&error]) {
		NSLog(@"%s [%d] Unresolved error %@, %@",__PRETTY_FUNCTION__, __LINE__ , error, [error userInfo]);
		abort();
	}
    
    id <NSFetchedResultsSectionInfo> sectionInfo = [[reportTypeFRC sections] objectAtIndex:0];
    NSInteger numberOfRows = [sectionInfo numberOfObjects];
    if (numberOfRows<=0) [self getURLReportType];
    
	[self loadReports];   
	[self addActionBtn];
}


- (void)viewWillAppear:(BOOL)animated {
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionCurlUp forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
    //[super viewWillAppear:animated];
    [self getCookies];
    [self loadReports];
    //    [self.tableView reloadData];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}

#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)dealloc {
	[fetchedResultsController release];
    [managedObjectContext release];
    [reportTypeFRC release];
    [myInfo release];
    
    //  [queryString release];
    //	[queryData release];
    //	[urlCon release];
	[rawData release];
	[dicData release];
    
    [deleteid release];
	
    [super dealloc];
}

@end

