
#import "OWLXMLParser.h"

@class Report;
@class ReportTableViewCell;

@interface smartReports : UITableViewController <NSFetchedResultsControllerDelegate, UIActionSheetDelegate, UISearchBarDelegate, OWLXMLParserDelegate> {
@private
	NSFetchedResultsController *fetchedResultsController;
	NSManagedObjectContext *managedObjectContext;
    
    IBOutlet UISearchBar * theSearchBar;
    
    NSString *queryString;
	NSData *queryData;
	NSURLConnection *urlCon;
	NSMutableData *rawData;
	NSMutableDictionary *dicData;
    NSString *lastid;
}

@property (nonatomic, retain) NSFetchedResultsController *fetchedResultsController;
@property (nonatomic, retain) NSManagedObjectContext *managedObjectContext;

@property (nonatomic, retain) NSString *queryString;
@property (nonatomic, retain) NSData *queryData;
@property (nonatomic, retain) NSURLConnection *urlCon;
@property (nonatomic, retain) NSMutableData *rawData;
@property (nonatomic, retain) NSMutableDictionary *dicData;
@property (nonatomic, retain) NSString *lastid;

- (void) loadReports;
- (void)configureCell:(ReportTableViewCell *)cell atIndexPath:(NSIndexPath *)indexPath;
- (void) addActionBtn;
- (IBAction) contextMenu:(id)sender;
- (void) selectTabBar:(NSString *) title;
- (void) showDetail:(Report *) report;
- (void) searchData;

- (void) deleteAllListed;
- (void) getURLReports;
- (void) handleError:(NSError *)error;
- (void) initReports:(NSMutableDictionary *) data;
- (NSDate *) getDateTimeFromString:(NSString *) dateString;
- (NSNumber *) string2Number:(NSString *) str;

@end
