
#import "smartReports.h"
#import "myReports.h"
#import "owllabSiteAppDelegate.h"

@implementation owllabSiteAppDelegate

@synthesize window;
@synthesize tabBarController;
@synthesize myInfo;
@synthesize managedObjectContext;

#pragma mark -
#pragma mark Application lifecycle

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {    
    
    [self loadSmartDataBase];
	smartReportsController.managedObjectContext = self.managedObjectContext;
	myReportsController.managedObjectContext = self.managedObjectContext;
    
    [self.window addSubview:tabBarController.view];
    [self.window makeKeyAndVisible];
	
	tabBarController.moreNavigationController.delegate = self;
    tabBarController.delegate = self;
	UITableView *moreView = (UITableView *)self.tabBarController.moreNavigationController.topViewController.view;
    moreView.delegate = self;
	myInfo = [[NSMutableDictionary alloc] init];
	
    return YES;
}


- (void)applicationWillResignActive:(UIApplication *)application {
    /*
     Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
     Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
     */
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    /*
     Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later. 
     If your application supports background execution, called instead of applicationWillTerminate: when the user quits.
     */
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
    /*
     Called as part of  transition from the background to the inactive state: here you can undo many of the changes made on entering the background.
     */
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    /*
     Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
     */
}


- (void)applicationWillTerminate:(UIApplication *)application {
	NSError *error;
    if (managedObjectContext != nil) {
        if ([managedObjectContext hasChanges] && ![managedObjectContext save:&error]) {
			NSLog(@"%s [%d] Unresolved error %@, %@", __PRETTY_FUNCTION__, __LINE__, error, [error userInfo]);
			abort();
        } 
    }
}


#pragma mark -
#pragma mark UITabBarControllerDelegate methods

- (BOOL)tabBarController:(UITabBarController *)tabBarController shouldSelectViewController:(UIViewController *)viewController {
	
	BOOL state = YES;
	
	[self getCookies];
	BOOL loginState = NO;
	if ([[myInfo objectForKey:@"suserdb.userid"] length]>0) loginState = YES;
	
	NSLog(@"didSelectViewController=%@", viewController);
	NSLog(@"%s [%d]: suserdb.userid:%@", __PRETTY_FUNCTION__, __LINE__, [myInfo objectForKey:@"suserdb.userid"]);
	
	NSString *title = viewController.tabBarItem.title;
	
	if ([title isEqualToString:@"Create ID"]) {
		if (loginState) {
			[self selectTabBar:@"My Info"];
			state = NO;
		}
	} else if ([title isEqualToString:@"Login"] || [title isEqualToString:@"Logout"]) {
		if (loginState) [self selectTabBar:@"Logout"];
		else [self selectTabBar:@"Login"];
		state = NO;
	} else if ([title isEqualToString:@"My Info"]) {
		if (!loginState) {
			[self loginAlert];
			state = NO;
		}
	} else if ([title isEqualToString:@"My Reports"]) {
		if (!loginState) {
			[self loginAlert];
			state = NO;
		}
    } 
	
	return state;
}

/**/
// Optional UITabBarControllerDelegate method.
- (void)tabBarController:(UITabBarController *)tabBarController didSelectViewController:(UIViewController *)viewController {
	
}


/**/
// Optional UITabBarControllerDelegate method.
- (void)tabBarController:(UITabBarController *)tabBarController didEndCustomizingViewControllers:(NSArray *)viewControllers changed:(BOOL)changed {
	
}

/*
- (void)tabBar:(UITabBar *)tabBar willBeginCustomizingItems:(NSArray *)items {
    UIView *edit_views = [tabBarController.view.subviews objectAtIndex:2];
    UINavigationBar *edit_modal_navbar  = [[edit_views subviews] objectAtIndex:0];
    edit_modal_navbar.barStyle = UIBarStyleBlackOpaque;
    edit_modal_navbar.topItem.title = @"More Menus";
}
*/
- (NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
	NSIndexPath * resultPath = nil;
	
	[self getCookies];
	BOOL loginState = NO;
	if ([[myInfo objectForKey:@"suserdb.userid"] length]>0) loginState = YES;
	
	NSLog(@"%s [%d]: suserdb.userid:%@",  __PRETTY_FUNCTION__, __LINE__, [myInfo objectForKey:@"suserdb.userid"]);
	
	UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
	
	if ([cell.textLabel.text isEqualToString:@"Create ID"]) {
		if (loginState) [self logoutAlert];
		else [self selectTabBar:@"Create ID"];
	} else if ([cell.textLabel.text isEqualToString:@"Login"] || [cell.textLabel.text isEqualToString:@"Logout"]) {
		if (loginState) [self selectTabBar:@"Logout"];
		else [self selectTabBar:@"Login"];
	} else if ([cell.textLabel.text isEqualToString:@"My Info"]) {
		if (loginState) [self selectTabBar:@"My Info"];
		else [self loginAlert];
    } else if ([cell.textLabel.text isEqualToString:@"My Reports"]) {
		if (loginState) [self selectTabBar:@"My Reports"];
		else [self loginAlert];
	} else {
		resultPath = indexPath;
	}
	return resultPath;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
	UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
	[self selectTabBar:cell.textLabel.text];
	
}


#pragma mark -
#pragma mark Memory management

- (void)applicationDidReceiveMemoryWarning:(UIApplication *)application {
    /*
     Free up as much memory as possible by purging cached data objects that can be recreated (or reloaded from disk) later.
     */
}


- (void)dealloc {
    [tabBarController release];
    [window release];
	[myInfo release];
    
    [managedObjectContext release];
	
    [super dealloc];
}

#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

#pragma mark -
#pragma mark UIView Access controls

- (void) logoutAlert {
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"계정생성안내" message:@"먼저 로그아웃한 후 새계정을 생성할 수 있습니다.\n로그아웃하시겠습니까?" delegate:self cancelButtonTitle:@"No" otherButtonTitles:@"Logout", @"My Info", nil];
	alert.cancelButtonIndex = 0;
	[alert show];
	[alert release];	
}

- (void) loginAlert {
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"로그인안내" message:@"먼저 로그인하세요.\n로그인하시겠습니까?" delegate:self cancelButtonTitle:@"No" otherButtonTitles:@"Login", nil];
	[alert show];
	[alert release];	
}

- (void) alertView:(UIAlertView *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
	if ([actionSheet title] == @"로그인안내") {
		if (buttonIndex==0) {
		} else {
			[self selectTabBar:@"Login"];
		}
	} else if ([actionSheet title] == @"계정생성안내") {
		if (buttonIndex==0) {
		} else if (buttonIndex==1) {
			[self selectTabBar:@"Logout"];
		} else {
			[self selectTabBar:@"My Info"];
		}
	}
}

- (void) selectTabBar:(NSString *) title {
	BOOL found = NO;
	for (int i=0; i<[tabBarController.customizableViewControllers count];i++) {
		NSLog(@"%@", [[tabBarController.customizableViewControllers objectAtIndex:i] nibName]);
		if ([[[tabBarController.viewControllers objectAtIndex:i] title] isEqualToString:title]) {
			tabBarController.selectedIndex = i;
			found = YES;
			break;
		}
	}
	if (found==NO) {
		tabBarController.selectedIndex = 0;
	}
}

#pragma mark -
#pragma mark Core Data stack

- (void) loadSmartDataBase {
    NSURL *documentUrl = [[[NSFileManager defaultManager] URLsForDirectory:NSDocumentDirectory inDomains:NSUserDomainMask] lastObject];
    NSURL *storeURL = [documentUrl URLByAppendingPathComponent:@"reports.sqlite"];
    NSError *error = nil;
    NSPersistentStoreCoordinator *persistentStoreCoordinator = [[NSPersistentStoreCoordinator alloc] initWithManagedObjectModel:[NSManagedObjectModel mergedModelFromBundles:nil]];
    if (![persistentStoreCoordinator addPersistentStoreWithType:NSSQLiteStoreType configuration:nil URL:storeURL options:nil error:&error]) {
        NSLog(@"%s [%d]: Unresolved error %@, %@", __PRETTY_FUNCTION__, __LINE__, error, [error userInfo]);
        abort();
    }
    managedObjectContext = [[NSManagedObjectContext alloc] init];
    [managedObjectContext setPersistentStoreCoordinator:persistentStoreCoordinator];
    [persistentStoreCoordinator release];
}

//
//- (NSManagedObjectContext *)managedObjectContext {
//    if (managedObjectContext != nil) {
//        return managedObjectContext;
//    }
//    NSPersistentStoreCoordinator *coordinator = [self persistentStoreCoordinator];
//    if (coordinator != nil) {
//        managedObjectContext = [[NSManagedObjectContext alloc] init];
//        [managedObjectContext setPersistentStoreCoordinator:coordinator];
//    }
//    return managedObjectContext;
//}
//
//
//- (NSManagedObjectModel *)managedObjectModel {
//    if (managedObjectModel != nil) {
//        return managedObjectModel;
//    }
//	
//	NSString *path = [[NSBundle mainBundle] pathForResource:@"reports" ofType:@"momd" ];
//	if (!path) { 
//		path = [[NSBundle mainBundle] pathForResource:@"reports" ofType:@"mom" ];
//	} 
//	NSAssert(path != nil, @"Unable to find DataModel in main bundle"); 
//	NSURL *url = [NSURL fileURLWithPath:path];
//	managedObjectModel = [[NSManagedObjectModel alloc] initWithContentsOfURL:url];
//	
//	
////    NSURL *modelURL = [[NSBundle mainBundle] URLForResource:@"reports" withExtension:@"momd"];
////	if (!modelURL) { 
////		modelURL = [[NSBundle mainBundle] URLForResource:@"reports" withExtension:@"mom" ];
////	}
////    managedObjectModel = [[NSManagedObjectModel alloc] initWithContentsOfURL:modelURL];    
//    return managedObjectModel;
//}
//
//
//- (NSPersistentStoreCoordinator *)persistentStoreCoordinator {
//    if (persistentStoreCoordinator != nil) {
//        return persistentStoreCoordinator;
//    }
//    NSURL *storeURL = [[self applicationDocumentsDirectory] URLByAppendingPathComponent:@"reports.sqlite"];
//	
//	NSDictionary *options = [NSDictionary dictionaryWithObjectsAndKeys:
//                             [NSNumber numberWithBool:YES], NSMigratePersistentStoresAutomaticallyOption,
//                             [NSNumber numberWithBool:YES], NSInferMappingModelAutomaticallyOption, nil];
//	
//    NSError *error = nil;
//    persistentStoreCoordinator = [[NSPersistentStoreCoordinator alloc] initWithManagedObjectModel:[self managedObjectModel]];
//    if (![persistentStoreCoordinator addPersistentStoreWithType:NSSQLiteStoreType configuration:nil URL:storeURL options:options error:&error]) {
//        NSLog(@"%s [%d]: Unresolved error %@, %@", __PRETTY_FUNCTION__, __LINE__, error, [error userInfo]);
//        abort();
//    }
//    return persistentStoreCoordinator;
//}


//#pragma mark -
//#pragma mark Application's Documents directory
//
//
//- (NSURL *)applicationDocumentsDirectory {
//    return [[[NSFileManager defaultManager] URLsForDirectory:NSDocumentDirectory inDomains:NSUserDomainMask] lastObject];
//}

@end

