
#import "noticeList.h"
#import "noticeDetail.h"
#import <CFNetwork/CFNetwork.h> //kCFURLErrorNotConnectedToInternet

//making the SSL Allowed.. /////////////////
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end
//making the SSL Allowed.. /////////////////

@implementation noticeList

//@synthesize dataA;
@synthesize mDataA, dataA, urlCon, rawData, oQueue;
@synthesize page, ipp, ten, totpage, startpage, totrec;

static NSString *titleKey = @"title";
static NSString *breifKey = @"brief";
static NSString *viewControllerKey = @"viewController";


#pragma mark -
#pragma mark Utility Actions
- (void) initPage {
	self.page = @"1";
	self.ipp = @"10";
	self.ten = @"5";
	self.totpage = @"5";
	self.startpage = @"1";
	self.totrec = @"0";
}

#pragma mark -
#pragma mark NSURLConnection
- (void) getURLData {
    
	self.mDataA = [NSMutableArray array];
	self.dataA = self.mDataA;
    
    //	NSString *url = @"http://www.owllab.com/ios/notice_list.php?page=0";
	
	NSString *url = @"https://www.owllab.com/ios/notice_list.php?page=0";
	
	//making the SSL Allowed.. /////////////////
//	NSURL *URL = [NSURL URLWithString:url];
//	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
	
	//GET//////////////
	//NSURLRequest *urlRequest = [NSURLRequest requestWithURL:[NSURL URLWithString:url]];
	
    
	//POST////////////////
	NSString *queryString = [NSString stringWithFormat: @"&page=%@&ipp=%@&ten=%@", page, ipp, ten];
	NSData *queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
	
	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString: url]];
	[urlRequest setHTTPMethod: @"POST"];
	[urlRequest setHTTPBody: queryData];
	NSLog(@"url: %@", url);
	NSLog(@"queryData: %@", [[[NSString alloc] initWithData:queryData encoding:NSUTF8StringEncoding] autorelease]);
	//POST////////////////
	
    self.urlCon = [[[NSURLConnection alloc] initWithRequest:urlRequest delegate:self] autorelease];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
	[url release];
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
    self.rawData = [NSMutableData data];
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    self.urlCon = nil;
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    self.urlCon = nil;
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	self.rawData = nil;
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];
}


#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    
	[self initPage];
	[self getURLData];
	
    //	noticeDetail *detailViewController = [[noticeDetail alloc] initWithNibName:@"noticeDetail" bundle:nil];
    //
    //	self.dataA = [NSMutableArray array];
    //	[self.dataA addObject:[NSDictionary dictionaryWithObjectsAndKeys: @"제목1  제목1제목1제목1제목1제목1제목1제목1제목1제목1제목1", titleKey, @"요약정보1 요약정보1 요약정보1 요약정보1 요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1.", breifKey, detailViewController, viewControllerKey, nil]];
    //	[self.dataA addObject:[NSDictionary dictionaryWithObjectsAndKeys: @"제목2 ", titleKey, @"요약정보2 실험용 데이터입니다.!@#$%^&*()", breifKey, detailViewController, viewControllerKey, nil]];
    //	
    //	[detailViewController release];
	
    //	UIBarButtonItem *temporaryBarButtonItem = [[UIBarButtonItem alloc] init];
    //	temporaryBarButtonItem.title = @"Back";
    //	self.navigationItem.backBarButtonItem = temporaryBarButtonItem;
    //	[temporaryBarButtonItem release];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	// this UIViewController is about to re-appear, make sure we remove the current selection in our table view
	NSIndexPath *tableSelection = [self.tableView indexPathForSelectedRow];
	[self.tableView deselectRowAtIndexPath:tableSelection animated:YES];
}

/*
 - (void)viewDidAppear:(BOOL)animated {
 [super viewDidAppear:animated];
 }
 *//*
    - (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    }
    *//*
       - (void)viewDidDisappear:(BOOL)animated {
       [super viewDidDisappear:animated];
       }
       *//*
          // Override to allow orientations other than the default portrait orientation.
          - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
          // Return YES for supported orientations.
          return (interfaceOrientation == UIInterfaceOrientationPortrait);
          }
          */

#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
	[super viewDidUnload];
	self.dataA = nil;
}

- (void)dealloc {
	
	[dataA release];
	
    [super dealloc];
}


#pragma mark -
#pragma mark Table view data source

/*
 - (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
 // Return the number of sections.
 return number of sections;
 }
 */

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
    //    return <#number of rows in section#>;
	int listCount = [self.dataA count];
    if (listCount == 0) {
        return 1;
    }
    return listCount;
	
}

// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    NSString *CellIdentifier = @"CellID";
    NSString *tmpCellIdentifier = @"tmpCell";
	
	int rowCount = [self.dataA count];
	
	if (rowCount == 0 && indexPath.row == 0) {
		UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:tmpCellIdentifier];
        if (cell == nil) {
            cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle
										   reuseIdentifier:tmpCellIdentifier] autorelease];   
            cell.detailTextLabel.textAlignment = UITextAlignmentCenter;
			cell.detailTextLabel.textColor = UIColor.orangeColor;
			cell.selectionStyle = UITableViewCellSelectionStyleNone;
        }
		cell.detailTextLabel.text = @"";
		return cell;	
	}
	
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
		cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier] autorelease];
        //		cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
		cell.accessoryType = UITableViewCellAccessoryDetailDisclosureButton;
    }
	
	if (rowCount > 0) {
		cell.textLabel.text = [[self.dataA objectAtIndex:indexPath.row] objectForKey:titleKey];
		cell.detailTextLabel.text = [[self.dataA objectAtIndex:indexPath.row] objectForKey:breifKey];
	}
    return cell;
}

/*
 // Override to support conditional editing of the table view.
 - (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the specified item to be editable.
 //    return YES;
 return NO;
 }
 *//*
    // Override to support editing the table view.
    - (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
    // Delete the row from the data source.
    [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
    // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view.
    }   
    }
    *//*
       // Override to support rearranging the table view.
       - (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
       }
       *//*
          // Override to support conditional rearranging of the table view.
          - (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
          // Return NO if you do not want the item to be re-orderable.
          return YES;
          }
          */

#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    // Navigation logic may go here. Create and push another view controller.
    /*
     // ...
     // Pass the selected object to the new view controller.
     [self.navigationController pushViewController:detailViewController animated:YES];
     [detailViewController release];
     */
    
	UIViewController *detailViewController = [[self.dataA objectAtIndex: indexPath.row] objectForKey:viewControllerKey];
    
	[self.navigationController pushViewController:detailViewController animated:YES];
}

/*
 - (void) setDataA:(NSMutableArray *)obj {
 if ( dataA != obj ) {
 [dataA release]; 
 dataA = [obj retain]; 
 }
 }
 */

@end

