
#import "helpDesk.h"
#import "webView.h"

#pragma mark -
#pragma mark making the SSL Allowed.. 
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end


@implementation helpDesk

@synthesize queryString, queryData, urlCon, rawData, adminInfo;

- (void)viewDidLoad {
    [super viewDidLoad];
	
	smsLabel.text = @"";
	telLabel.text = @"";
	emailLabel.text = @"";
	webLabel.text = @"";
	addressLabel.text = @"";
	
	[self getURLData];
}


- (void) viewWillAppear:(BOOL)animated {
	[super viewWillAppear:animated];
	
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionFlipFromLeft forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
}

/*
 // Override to allow orientations other than the default portrait orientation.
 - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
 // Return YES for supported orientations.
 return (interfaceOrientation == UIInterfaceOrientationPortrait);
 }
 */

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)viewDidUnload {
    [super viewDidUnload];
}


- (void)dealloc {
	[queryString release];
	[queryData release];
	[urlCon release];
	[rawData release];
	[adminInfo release];
	
    [super dealloc];
}


#pragma mark -
#pragma mark NSURLConnection

- (void) getURLData {
	
	NSString *url = @"https://www.owllab.com/ios/admin_info.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
	
	queryString = @"";
	queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
	
	//POST////////////////
	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString: url]];
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];
	
	NSLog(@"url: %@", url);
	NSLog(@"queryData: %@", [[[NSString alloc] initWithData:queryData encoding:NSUTF8StringEncoding] autorelease]);
	//POST////////////////
	
    self.urlCon = [[[NSURLConnection alloc] initWithRequest:urlRequest delegate:self] autorelease];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
	[url release];
	[urlRequest release];
	
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
	self.rawData = [NSMutableData data];
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    self.urlCon = nil;
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    self.urlCon = nil;
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	
	NSMutableDictionary *xmlDic = [[NSMutableDictionary alloc] init];
	[xmlDic setObject:@"info" forKey:@"infoTag"];
	[xmlDic setObject:@"data" forKey:@"dataTag"];
	[xmlDic 
	 setObject:[NSArray arrayWithObjects:@"result", @"msg", nil] 
	 forKey:@"infoFields"];
	[xmlDic 
	 setObject:[NSArray arrayWithObjects:@"sms", @"tel", @"email", @"web", @"address", nil] 
	 forKey:@"dataFields"];
	
	OWLXMLParser *parser = [[OWLXMLParser alloc] initWithData:rawData delegate:self xmlInfo:xmlDic];
	[parser startParse];
	[parser release];
	[xmlDic release];
	self.rawData = nil;
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];
}


#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSMutableDictionary *) resultDic {
	[self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:resultDic waitUntilDone:NO];
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSMutableDictionary *)loadedDic {
	int result = [[[loadedDic objectForKey:@"info"] objectForKey:@"result"] intValue];
	BOOL alertState = YES;
	if (result == 1) {
		[adminInfo release];
		adminInfo = [[[loadedDic objectForKey:@"data"] objectAtIndex:0] copy];
		
		smsLabel.text = [adminInfo objectForKey:@"sms"];
		telLabel.text = [adminInfo objectForKey:@"tel"];
		emailLabel.text = [adminInfo objectForKey:@"email"];
		webLabel.text = [adminInfo objectForKey:@"web"];
		addressLabel.text = [adminInfo objectForKey:@"address"];
		
		alertState = NO;
	}
	
	if (alertState) {
		UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"안내" message:@"" delegate:self cancelButtonTitle:@"확인" otherButtonTitles:nil];
		alertView.message = [[loadedDic objectForKey:@"info"] objectForKey:@"죄송합니다.\n관리자정보를 가져오지 못했습니다."];
		[alertView show];
		[alertView release];
	}
	
}

#pragma mark -
#pragma mark UIApplication openURL

- (void) gotoURL:(NSString *) strUrl {
	NSLog(@"%@",strUrl);
	NSURL *theUrl = [NSURL URLWithString:strUrl];
	[[UIApplication sharedApplication] openURL:theUrl];
}

#pragma mark -
#pragma mark IBAction

- (IBAction) gotoSMS:(id)sender {
	NSString *strUrl = [NSString stringWithFormat:@"sms://%@",[adminInfo objectForKey:@"sms"]];
	[self gotoURL:strUrl];
}

- (IBAction) gotoTel:(id)sender{
	NSString *strUrl = [NSString stringWithFormat:@"tel://%@",[adminInfo objectForKey:@"tel"]];
	[self gotoURL:strUrl];
}

- (IBAction) gotoEmail:(id)sender{
	NSString *strUrl = [NSString stringWithFormat:@"mailto://%@",[adminInfo objectForKey:@"email"]];
	[self gotoURL:strUrl];
}

- (IBAction) gotoWeb:(id)sender{
	NSLog(@"%@",adminInfo);
	NSString *strUrl = [NSString stringWithFormat:@"http://%@",[adminInfo objectForKey:@"web"]];
	//[self gotoURL:strUrl];
	[self gotoWebView:strUrl];
}

- (IBAction) gotoMap:(id)sender{
	NSString *address = [[adminInfo objectForKey:@"address"] stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
	NSString *strUrl = [NSString stringWithFormat:@"http://maps.google.com/maps?q=%@",address];
	//NSString *strUrl = @"http://maps.google.com/maps?f=d&saddr=37.566535%20126.977969&daddr=37.5237762%20127.0224608&hl=ko";
	//http://maps.google.com/maps?f=d&saddr=37.566535%20126.977969&daddr=37.5237762%20127.0224608&hl=ko
	//[self gotoURL:strUrl];
	[self gotoWebView:strUrl];
}

- (IBAction) reloadAdmin:(id)sender {
	[self getURLData];
}

- (void) showURL:(NSURL *)address withTitle:(NSString *)title {
	
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionCurlUp forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
	
	webView *vc = [[webView alloc] initWithNibName:@"webView" bundle:nil];	
	vc.title =  title;
	vc.webUrl = address;
	[self.navigationController pushViewController:vc animated:YES];
	[vc release];
}

- (void) gotoWebView:(NSString *) strUrl {
	NSLog(@"%@",strUrl);
	NSURL *theUrl = [NSURL URLWithString:strUrl];
	[self showURL:theUrl withTitle:@"고객센터"];
}

@end
