

#import <UIKit/UIKit.h>
#import <MediaPlayer/MediaPlayer.h>
#import "OWLXMLParser.h"

@class Report;

@interface smartView : UITableViewController <UITextFieldDelegate, UITextViewDelegate, UIImagePickerControllerDelegate, UINavigationControllerDelegate, UIVideoEditorControllerDelegate, OWLXMLParserDelegate> {
    
    IBOutlet UIView *tableHeaderView;
    IBOutlet UITextField *inputSubject;
    IBOutlet UITextField *inputWriter;
    IBOutlet UITextField *inputRegDate;
    IBOutlet UITextField *inputRowid;
    IBOutlet UIButton *photoButton;
    IBOutlet UIButton *movieButton;
    IBOutlet UISwitch *publishSwitch;
    IBOutlet UITextView *inputContent;
    
@private
	Report *report;
    NSMutableDictionary *myInfo;
    
    MPMoviePlayerViewController *theMoviePlayer;
    
    NSString *uploadType;
    NSMutableDictionary* dicParm;
	NSMutableData *rawData;
	NSMutableDictionary *dicData;
    
    UIImage *movieThumb;
}

@property (nonatomic, retain) Report *report;
@property (nonatomic, retain) NSMutableDictionary *myInfo;

@property (nonatomic, retain) MPMoviePlayerViewController *theMoviePlayer;

@property (nonatomic, retain) NSMutableDictionary *dicParm;
@property (nonatomic, retain) NSString *uploadType;
@property (nonatomic, retain) NSMutableData *rawData;
@property (nonatomic, retain) NSMutableDictionary *dicData;

@property (nonatomic, retain) UIImage *movieThumb;

- (IBAction)selectPhoto:(id)sender;
- (IBAction)selectMovie:(id)sender;
- (IBAction)setPublish:(id)sender;

- (void) getCookies;
- (NSString *) getDateTime:(NSDate *) theDate;

- (UIImage *) makeThumbnail:(NSURL *) theURL;
- (void) saveMovieFile:(NSURL *) theURL fileName:(NSString *) filename;
- (void) editMovie:(NSString *) thePath;
- (NSString *) getDateTimeName:(NSDate *) theDate;
- (void) playMovieAtURL:(NSURL*)theURL;
- (NSURL *) localMovieURL;

- (void) putURLData;
- (IBAction) uploadData;
- (void)handleError:(NSError *)error;
- (NSString *) makeBoundaryString;
- (NSDate *) getDateTimeFromString:(NSString *) dateString;
- (NSNumber *) string2Number:(NSString *) str;
- (void) playStreamAtURL:(NSURL*)theURL;

@end
