
#import "noticeList.h"
#import "noticeDetail.h"
#import <CFNetwork/CFNetwork.h> //kCFURLErrorNotConnectedToInternet

#import "notice.h"
#import "noticeInfo.h"
#import "noticeParseOperation.h"


//making the SSL Allowed.. /////////////////
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end
//making the SSL Allowed.. /////////////////

@implementation noticeList

//@synthesize dataA;
//@synthesize mDataA, dataA, urlCon, rawData, oQueue;
@synthesize mDataA;
@synthesize dataA;
@synthesize urlCon;
@synthesize rawData;
@synthesize oQueue;
@synthesize page, ipp, ten, totpage, startpage, totrec;
@synthesize pageControl;
@synthesize pageTextView;
@synthesize summaryTextView;

@synthesize theSearchBar, keyfield, keyword;
@synthesize filteredListContent, savedSearchTerm, savedScopeButtonIndex, searchWasActive;

/*Leak Test ------------------------------*/
@synthesize queryString, queryData;


//static NSString *titleKey = @"title";
//static NSString *breifKey = @"brief";
//static NSString *viewControllerKey = @"viewController";


#pragma mark -
#pragma mark Utility Actions

- (IBAction) gotoSearch:(id)sender {
	noticeList *noticeSearch = [[noticeList alloc] initWithNibName:@"noticeSearch" bundle:nil];
	noticeSearch.title = @"Notice Search";
	[self.navigationController pushViewController:noticeSearch animated:YES];
}

- (void) gotoPage: (NSString *) thePage  {
	self.page = thePage;
	[self getURLData];
}

- (IBAction) nextPage {
	int pageInt = [self.page intValue];
	int totpageInt = [self.totpage intValue];
	pageInt++;
	if (pageInt>totpageInt) pageInt = totpageInt;
	self.page = [NSString stringWithFormat: @"%d", pageInt];
	[self getURLData];
}

- (IBAction) prevPage {
	int pageInt = [self.page intValue];
	pageInt--;
	if (pageInt<1) pageInt = 1;
	self.page = [NSString stringWithFormat: @"%d", pageInt];
	[self getURLData];
}


- (IBAction)changePage:(id)sender {
	self.page = [NSString stringWithFormat: @"%d", pageControl.currentPage + 1];
	[self getURLData];
}

- (IBAction)reloadPage:(id)sender {
	[self getURLData];
}

- (IBAction)firstPage:(id)sender {
	self.page = @"1";
	[self getURLData];
}

- (IBAction)lastPage:(id)sender {
	self.page = totpage;
	[self getURLData];
}

- (void) initPage {
	self.page = @"1";
	self.ipp = @"10";
    //	self.ipp = @"1";
	self.ten = @"5";
	self.totpage = @"5";
	self.startpage = @"1";
	self.totrec = @"0";
	self.keyfield = @"";
	self.keyword = @"";
}

#pragma mark -
#pragma mark NSURLConnection
- (void) getURLData {
    
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionCurlUp forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
	
	pageControl.numberOfPages = [self.totpage intValue];
	pageControl.currentPage = [self.page intValue]-1;
	
	self.mDataA = [NSMutableArray array];
	self.dataA = self.mDataA;
	
	self.filteredListContent = [NSMutableArray arrayWithCapacity:[self.dataA count]];
    if (self.savedSearchTerm) {
        [self.searchDisplayController setActive:self.searchWasActive];
        [self.searchDisplayController.searchBar setSelectedScopeButtonIndex:self.savedScopeButtonIndex];
        [self.searchDisplayController.searchBar setText:savedSearchTerm];
        self.savedSearchTerm = nil;
    }
    
    //	NSString *url = @"http://www.owllab.com/ios/notice_list.php?page=0";
	
	NSString *url = @"https://www.owllab.com/ios/notice_list.php?page=0";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
	
	//GET//////////////
	//NSURLRequest *urlRequest = [NSURLRequest requestWithURL:[NSURL URLWithString:url]];
	
    
	//POST////////////////
	
    //	NSString *queryString = [NSString stringWithFormat: @"&page=%@&ipp=%@&ten=%@", page, ipp, ten];
	/*Leak Test 
     NSString *queryString = [NSString stringWithFormat: @"&page=%@&ipp=%@&ten=%@&keyfield=%@&keyword=%@", page, ipp, ten, keyfield, [keyword stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
     
     NSData *queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
     ------------------------------*/
	
	queryString = [NSString stringWithFormat: @"&page=%@&ipp=%@&ten=%@&keyfield=%@&keyword=%@", page, ipp, ten, keyfield, [keyword stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
	
	queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
	
    
	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString: url]];
	[urlRequest setHTTPMethod: @"POST"];
	[urlRequest setHTTPBody: queryData];
	NSLog(@"url: %@", url);
	NSLog(@"queryData: %@", [[[NSString alloc] initWithData:queryData encoding:NSUTF8StringEncoding] autorelease]);
	//POST////////////////
	
    self.urlCon = [[[NSURLConnection alloc] initWithRequest:urlRequest delegate:self] autorelease];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
	[url release];
	/*Leak Test ------------------------------*/
	[urlRequest release];
    
	
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
    self.rawData = [NSMutableData data];
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    self.urlCon = nil;
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    self.urlCon = nil;
	
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	
	self.oQueue = [[[NSOperationQueue alloc] init] autorelease];
	/*Leak Test
     self.oQueue = [[NSOperationQueue alloc] init];
	 ----------------------------*/
    
    noticeParseOperation *parser = [[noticeParseOperation alloc] initWithData:rawData delegate:self];
    [oQueue addOperation:parser];
    [parser release];
    
	//	NSXMLParser *parser = [[NSXMLParser alloc] initWithData:rawData];
	//	parser.delegate = self;
	//    [parser parse];
	//    [parser release];
	
	self.rawData = nil;
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    //[alertView show];
    [alertView release];
}

#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSArray *)appList withInfo:(NSArray *)appInfo {
	
    //	if ([appList count]==0) {
    //		NSArray *workingEntry = [[[notice alloc] init] autorelease];
    //		appList = [NSArray arrayWithObjects:workingEntry, nil];
    //	}
    //	if ([appInfo count]==0) {
    //		NSArray *infoEntry = [[[noticeInfo alloc] init] autorelease];
    //		appInfo = [NSArray arrayWithObjects:infoEntry, nil];
    //	}
	
	NSArray *appAll = [NSArray arrayWithObjects:appList, appInfo, nil];
    [self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:appAll waitUntilDone:NO];
    self.oQueue = nil;
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSArray *)loadedApps {
	
    [self.mDataA addObjectsFromArray:[loadedApps objectAtIndex:0]];
	self.dataA = self.mDataA;
	
	noticeInfo *noticeInfoTmp = [[loadedApps objectAtIndex:1] objectAtIndex:0];
	self.totpage = noticeInfoTmp.totpage;
	self.startpage = noticeInfoTmp.startpage;
	self.totrec = noticeInfoTmp.totrec;
	self.page = noticeInfoTmp.page;
	self.ipp = noticeInfoTmp.ipp;
	self.ten = noticeInfoTmp.ten;
    
	self.pageTextView.text = [NSString stringWithFormat:@"Page : %@ / %@", self.page, self.totpage];
	//	self.pageTextView.textAlignment = UITextAlignmentLeft;
	self.pageTextView.font = [UIFont fontWithName:@"Helvetica" size:14];
	
	self.summaryTextView.text = [NSString stringWithFormat:@"Total : %@ recs", self.totrec];
	//	self.summaryTextView.textAlignment = UITextAlignmentRight;
	self.summaryTextView.font = [UIFont fontWithName:@"Helvetica" size:14];
	
	pageControl.numberOfPages = [self.totpage intValue];
	pageControl.currentPage = [self.page intValue]-1;
	
	[self.tableView reloadData];
}


#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    
	[self initPage];
	[self getURLData];
	
    //	noticeDetail *detailViewController = [[noticeDetail alloc] initWithNibName:@"noticeDetail" bundle:nil];
    //
    //	self.dataA = [NSMutableArray array];
    //	[self.dataA addObject:[NSDictionary dictionaryWithObjectsAndKeys: @"제목1  제목1제목1제목1제목1제목1제목1제목1제목1제목1제목1", titleKey, @"요약정보1 요약정보1 요약정보1 요약정보1 요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1요약정보1.", breifKey, detailViewController, viewControllerKey, nil]];
    //	[self.dataA addObject:[NSDictionary dictionaryWithObjectsAndKeys: @"제목2 ", titleKey, @"요약정보2 실험용 데이터입니다.!@#$%^&*()", breifKey, detailViewController, viewControllerKey, nil]];
    //	
    //	[detailViewController release];
	
    //	UIBarButtonItem *temporaryBarButtonItem = [[UIBarButtonItem alloc] init];
    //	temporaryBarButtonItem.title = @"Back";
    //	self.navigationItem.backBarButtonItem = temporaryBarButtonItem;
    //	[temporaryBarButtonItem release];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	// this UIViewController is about to re-appear, make sure we remove the current selection in our table view
	NSIndexPath *tableSelection = [self.tableView indexPathForSelectedRow];
	[self.tableView deselectRowAtIndexPath:tableSelection animated:YES];
}

/*
 - (void)viewDidAppear:(BOOL)animated {
 [super viewDidAppear:animated];
 }
 *//*
    - (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    }
    *//*
       - (void)viewDidDisappear:(BOOL)animated {
       [super viewDidDisappear:animated];
       }
       */

- (void)viewDidDisappear:(BOOL)animated {
    self.searchWasActive = [self.searchDisplayController isActive];
    self.savedSearchTerm = [self.searchDisplayController.searchBar text];
    self.savedScopeButtonIndex = [self.searchDisplayController.searchBar selectedScopeButtonIndex];
}

/*
 // Override to allow orientations other than the default portrait orientation.
 - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
 // Return YES for supported orientations.
 return (interfaceOrientation == UIInterfaceOrientationPortrait);
 }
 */

#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
	[super viewDidUnload];
	self.dataA = nil;
	self.filteredListContent = nil;
}

- (void)dealloc {
	
	[mDataA release];
	[dataA release];
	[urlCon release];
	[rawData release];
	[oQueue release];
	
	[page release];
	[ipp release];
	[ten release];
	[totpage release];
	[totrec release];
	
	[pageControl release];
	[pageTextView release];
	[summaryTextView release];
	
	[theSearchBar release];
	[keyfield release];
	[keyword release];
	[filteredListContent release];
	[savedSearchTerm release];
    //	[savedScopeButtonIndex release];
    //	[searchWasActive release];
	
	/* Leak Test ------------------------------*/
	[oQueue release];
	[queryString release];
	[queryData release];
    
	
    [super dealloc];
}


#pragma mark -
#pragma mark Table view data source

/*
 - (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
 // Return the number of sections.
 return number of sections;
 }
 */

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
    //    return <#number of rows in section#>;
    //	int listCount = [self.dataA count];
    //    if (listCount == 0) {
    //        return 1;
    //    }
    //    return listCount;
	
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        return [self.filteredListContent count];
    } else {
        return [self.dataA count];
    }
	
}

// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    NSString *CellIdentifier = @"CellID";
    NSString *tmpCellIdentifier = @"tmpCell";
	
	int rowCount = [self.dataA count];
	
	if (rowCount == 0 && indexPath.row == 0) {
		UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:tmpCellIdentifier];
        if (cell == nil) {
            cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle
										   reuseIdentifier:tmpCellIdentifier] autorelease];   
            cell.detailTextLabel.textAlignment = UITextAlignmentCenter;
			cell.detailTextLabel.textColor = UIColor.orangeColor;
			cell.selectionStyle = UITableViewCellSelectionStyleNone;
        }
		cell.detailTextLabel.text = @"";
		return cell;	
	}
	
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
		cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier] autorelease];
        //		cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
		cell.accessoryType = UITableViewCellAccessoryDetailDisclosureButton;
    }
	
	if (rowCount > 0) {
		
		notice *noticeRow = nil;
        //		noticeRow = [self.dataA objectAtIndex:indexPath.row];
		
		if (tableView == self.searchDisplayController.searchResultsTableView) {
			noticeRow = [self.filteredListContent objectAtIndex:indexPath.row];
		} else {
			noticeRow = [self.dataA objectAtIndex:indexPath.row];
		}
        
		cell.textLabel.text = noticeRow.subject;
		cell.detailTextLabel.text = noticeRow.reg_date;
		
        //		cell.textLabel.text = [[self.dataA objectAtIndex:indexPath.row] objectForKey:titleKey];
        //		cell.detailTextLabel.text = [[self.dataA objectAtIndex:indexPath.row] objectForKey:breifKey];
	}
    return cell;
}

/*
 // Override to support conditional editing of the table view.
 - (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the specified item to be editable.
 //    return YES;
 return NO;
 }
 *//*
    // Override to support editing the table view.
    - (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
    // Delete the row from the data source.
    [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
    // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view.
    }   
    }
    *//*
       // Override to support rearranging the table view.
       - (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
       }
       *//*
          // Override to support conditional rearranging of the table view.
          - (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
          // Return NO if you do not want the item to be re-orderable.
          return YES;
          }
          */

#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    // Navigation logic may go here. Create and push another view controller.
    /*
     // ...
     // Pass the selected object to the new view controller.
     [self.navigationController pushViewController:detailViewController animated:YES];
     [detailViewController release];
     */
    
    //	UIViewController *detailViewController = [[self.dataA objectAtIndex: indexPath.row] objectForKey:viewControllerKey];
	
	noticeDetail *detailViewController = [[noticeDetail alloc] initWithNibName:@"noticeDetail" bundle:nil];
	
	notice *noticeRow = nil;
    //    noticeRow = [self.dataA objectAtIndex:indexPath.row];
    
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        noticeRow = [self.filteredListContent objectAtIndex:indexPath.row];
    } else {
        noticeRow = [self.dataA objectAtIndex:indexPath.row];
    }
	
	detailViewController.title = [NSString stringWithFormat:@"%@. %@", noticeRow.rowid, noticeRow.subject];
	
	detailViewController.viewData = noticeRow;
    
	[self.navigationController pushViewController:detailViewController animated:YES];
}

/*
 - (void) setDataA:(NSMutableArray *)obj {
 if ( dataA != obj ) {
 [dataA release]; 
 dataA = [obj retain]; 
 }
 }
 */

#pragma mark -
#pragma mark UISearchBarDelegate

- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar {
	[self.theSearchBar resignFirstResponder];
	[self searchData];
}


- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
	[self.theSearchBar resignFirstResponder];
}

- (void)searchData {
	self.keyword = self.theSearchBar.text;
	if (self.theSearchBar.selectedScopeButtonIndex==1) self.keyfield = @"reg_date";
	else  self.keyfield = @"subject";
	self.page = @"1";
	[self getURLData];
}

#pragma mark -
#pragma mark Content Filtering

- (void)filterContentForSearchText:(NSString*)searchText scope:(NSString*)scope {
	[self.filteredListContent removeAllObjects]; 
	
	self.keyword = searchText;
	if ([scope isEqualToString:@"일자"]) self.keyfield = @"reg_date";
	else  self.keyfield = @"subject";
	
	for (notice *noticeTmp in dataA) {
		NSComparisonResult result = [noticeTmp.subject compare:searchText options:(NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch) range:NSMakeRange(0, [searchText length])];
		if (result == NSOrderedSame) {
			[self.filteredListContent addObject:noticeTmp];
		}
	}
}

#pragma mark -
#pragma mark UISearchDisplayController Delegate Methods

- (BOOL)searchDisplayController:(UISearchDisplayController *)controller shouldReloadTableForSearchString:(NSString *)searchString {
    [self filterContentForSearchText:searchString scope:
	 [[self.searchDisplayController.searchBar scopeButtonTitles] objectAtIndex:[self.searchDisplayController.searchBar selectedScopeButtonIndex]]];
    return YES;
}


- (BOOL)searchDisplayController:(UISearchDisplayController *)controller shouldReloadTableForSearchScope:(NSInteger)searchOption {
    [self filterContentForSearchText:[self.searchDisplayController.searchBar text] scope:
	 [[self.searchDisplayController.searchBar scopeButtonTitles] objectAtIndex:searchOption]];
    return YES;
}

@end

