package com.owl.sample;

import java.util.HashMap;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.DialogInterface;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ListView;
import android.widget.Toast;

public class scoreActivity extends Activity {
	
	Activity act = this;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.score);
        listScore();
    }
    
    public static final String uriString = "content://com.owl.sample.ContentProvider/score";
	public static final Uri CONTENT_URI = Uri.parse(uriString);
	ContentResolver cr;
	
    public void listScore() {
    	cr = this.getContentResolver();
    	
		String[] projection = null;
		String selection = null;
		String[] selectionArgs = null;
		String sortOrder = "num desc";
		Cursor cursor = cr.query(CONTENT_URI, projection, selection, selectionArgs, sortOrder);
		HashMap<String, String> hm = cursor2HashMap(cursor);
		cursor.close();
		
		scoreListAdapter listAdapter = new scoreListAdapter(act, R.layout.score_row, hm);
		ListView listView = (ListView) act.findViewById(R.id.listView1);
		listView.setAdapter(listAdapter);
	}
    
    public void deleteAllScores(View view) {
    	AlertDialog adg = new AlertDialog.Builder(act)
        .setTitle("확인")
        .setMessage("장말로 삭제하시겠습니까?")
        .setPositiveButton("예", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				cr.delete(CONTENT_URI, null, null);
				listScore();
				String tmp = "기록을 모두 삭제했습니다.";
				Toast.makeText(act.getBaseContext(), tmp, Toast.LENGTH_LONG).show();
				return;
			}
        })
        .setNegativeButton("아니오", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
			}
        })
        .create();
    	adg.show();
    }
    
    public HashMap<String, String> cursor2HashMap(Cursor cursor) {
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put("count", "0");
		cursor.getColumnNames();
		try {
			int i = 0;
			while (cursor.moveToNext()) {
				for (int j = 0; j < cursor.getColumnCount(); j++) {
					String fieldName = cursor.getColumnName(j);
					String fieldValue = cursor.getString(j);
					hm.put(fieldName + "[" + i + "]", fieldValue);
				}// for j
				i++;
			}// while
			hm.put("count", Integer.toString(i));
		} catch (Exception e) {
			Log.e("cursor2HashMap", e.getMessage());
		}
		return hm;
	}
    
    public void gotoBack(View view) {
    	act.onBackPressed();
    }
}
