package com.owl.sample;

import java.io.InputStream;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.provider.ContactsContract.Contacts;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.CommonDataKinds.Email;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.StructuredPostal;
import android.provider.ContactsContract.CommonDataKinds.Website;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class QuickContactBadgeActivity extends Activity {
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		TextView tv1 = (TextView) findViewById(R.id.TextView01);
		TextView tv2 = (TextView) findViewById(R.id.TextView02);

		QuickContactBadge qcb1 = (QuickContactBadge) findViewById(R.id.QuickContactBadge01);
		qcb1.assignContactFromPhone(tv1.getText().toString(), true);
		qcb1.setMode(ContactsContract.QuickContact.MODE_LARGE);

		QuickContactBadge qcb2 = (QuickContactBadge) findViewById(R.id.QuickContactBadge02);
		qcb2.assignContactFromEmail(tv2.getText().toString(), true);
		qcb2.setMode(ContactsContract.QuickContact.MODE_SMALL);

	}

	private static final int CONTACT_PICKER_RESULT = 1001;
	
	public void pickContact(View view) {
		Intent contactPickerIntent = new Intent(Intent.ACTION_PICK,
				Contacts.CONTENT_URI);
		startActivityForResult(contactPickerIntent, CONTACT_PICKER_RESULT);
	}

	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (resultCode == RESULT_OK) {
			switch (requestCode) {
			case CONTACT_PICKER_RESULT:
				
				LinearLayout badgeLayout = (LinearLayout) findViewById(R.id.linearLayout1);

				LinearLayout itemLayout = new LinearLayout(this);
				itemLayout.setGravity(Gravity.CENTER_VERTICAL);
				LinearLayout.LayoutParams itemLayoutParams = new LinearLayout.LayoutParams(
						LinearLayout.LayoutParams.WRAP_CONTENT,
						LinearLayout.LayoutParams.WRAP_CONTENT);
				itemLayoutParams.setMargins(0, 0, 0, 10);
				itemLayout.setLayoutParams(itemLayoutParams);
				badgeLayout.addView(itemLayout);
				
				Uri contactUri = data.getData();

				QuickContactBadge newBadge = new QuickContactBadge(this);
				newBadge.assignContactUri(contactUri);

				long contactId = Long
						.parseLong(contactUri.getLastPathSegment());

				Bitmap cimage = getContactPhoto(contactId);
				if (cimage != null) {
					newBadge.setImageBitmap(cimage);
				} else {
					newBadge.setImageResource(R.drawable.ic_contact_picture);
				}
				newBadge.setMode(ContactsContract.QuickContact.MODE_LARGE);
				itemLayout.addView(newBadge);

				LinearLayout infoLayout = new LinearLayout(this);
				infoLayout.setGravity(Gravity.CENTER_VERTICAL);
				infoLayout.setOrientation(LinearLayout.VERTICAL);
				LinearLayout.LayoutParams infoLayoutParams = new LinearLayout.LayoutParams(
						LinearLayout.LayoutParams.WRAP_CONTENT,
						LinearLayout.LayoutParams.WRAP_CONTENT);
				infoLayoutParams.setMargins(10, 0, 0, 0);
				infoLayout.setLayoutParams(infoLayoutParams);
				itemLayout.addView(infoLayout);

				String[] ContactsProjection = new String[] {
						ContactsContract.Contacts._ID,
						ContactsContract.Contacts.DISPLAY_NAME };

				Cursor contactInfo = this.managedQuery(
						ContactsContract.Contacts.CONTENT_URI,
						ContactsProjection, ContactsContract.Contacts._ID
								+ "='" + contactId + "'", null, null);
				while (contactInfo.moveToNext()) {
					String data1 = contactInfo.getString(contactInfo
							.getColumnIndex(Contacts.DISPLAY_NAME));
					if (data1 != null) {
						TextView phoneView = new TextView(this);
						phoneView.setTextAppearance(getApplicationContext(),
								android.R.style.TextAppearance_Medium);
						phoneView.setText(data1);
						infoLayout.addView(phoneView);
					}
				}

				String[] dataProjection = new String[] { Phone.NUMBER,
						Email.DATA1 , Data.DATA1};

				Cursor dataInfo = this.managedQuery(Data.CONTENT_URI,
						dataProjection, Data.CONTACT_ID + " = ?" + " AND "
								+ Data.MIMETYPE + " in " + "('"
								+ Phone.CONTENT_ITEM_TYPE + "','"
								+ Email.CONTENT_ITEM_TYPE + "','"
								+ StructuredPostal.CONTENT_ITEM_TYPE + "','"
								+ Website.CONTENT_ITEM_TYPE + "')",
						new String[] { String.valueOf(contactId) }, Phone.TYPE
								+ " ASC");
				if (dataInfo.getCount() > 0) {
					while (dataInfo.moveToNext()) {
						String data1 = dataInfo.getString(dataInfo
								.getColumnIndex(Data.DATA1));
						if (data1 != null) {
							TextView phoneView = new TextView(this);
							phoneView.setTextAppearance(
									getApplicationContext(),
									android.R.style.TextAppearance_Medium);
							phoneView.setText(data1);
							infoLayout.addView(phoneView);
						}
					}
					dataInfo.close();
				}

				break;
			}
		}
	}

	private Bitmap getContactPhoto(long id) {
		Uri tmpUri = ContentUris.withAppendedId(
				ContactsContract.Contacts.CONTENT_URI, id);
		InputStream photoInput = ContactsContract.Contacts
				.openContactPhotoInputStream(this.getContentResolver(), tmpUri);
		if (photoInput != null) {
			return BitmapFactory.decodeStream(photoInput);
		}
		return null;
	}

}