package com.owl.sample;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public class NetworkXMLActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        loadList();
    }

    public void reLoadList(View view) {
    	loadList();
    }
    
    HashMap<String, String> hm = new HashMap<String, String>();
    public void loadList() {
    	String theUrl = "http://www.owllab.com/android2/food_list.xml";
		cmsHTTP cmsHttp = new cmsHTTP();
		cmsHttp.encoding = "UTF-8";
		cmsHttp.act = this;
		String tmpData = cmsHttp.sendGet(theUrl);
		if (tmpData==null) return;
		hm = xml2HashMap(tmpData, "UTF-8");
		theListAdapter listAdapter = new theListAdapter(this, R.layout.list_row, hm);
		ListView listView = (ListView) findViewById(R.id.listView1);
		listView.setAdapter(listAdapter);
	}
    
    public HashMap<String, String> xml2HashMap(String tmpData, String encoding) {
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put("count", "0");
		try {
			DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
			DocumentBuilder docB = docBF.newDocumentBuilder();
			InputStream is = new ByteArrayInputStream(tmpData.getBytes(encoding));
			Document doc = docB.parse(is);
			Element lists = doc.getDocumentElement();
			NodeList dataList = lists.getElementsByTagName("data");
			int c = 0;
			for (int i = 0; i < dataList.getLength(); i++) {
				NodeList dataNodeList = dataList.item(i).getChildNodes();
				for (int j = 0; j < dataNodeList.getLength(); j++) {
					Node itemNode = dataNodeList.item(j);
					if (itemNode.getFirstChild() != null) {
						String nodeName = itemNode.getNodeName();
						String nodeValue = itemNode.getFirstChild().getNodeValue();
						hm.put(nodeName + "[" + i + "]", nodeValue);
					}
				}// for j
				c++;
			}// for i
			hm.put("count", Integer.toString(c));
		} catch (Exception e) {
			Log.e("com.cms.sample.xml2HashMap", e.getMessage());
		}
		return hm;
	}
    
    
    class theListAdapter extends BaseAdapter {

    	LayoutInflater inflater;
    	HashMap<String, String> hm;
    	Context mContext;
    	int mListLayout;
    	public int listCount = 0;

    	public theListAdapter(Context tContext, int listLayout
    			, HashMap<String, String> tmpHm) {
    		mContext = tContext;
    		mListLayout = listLayout;
    		hm = tmpHm;
    		inflater = (LayoutInflater) mContext
    				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    		listCount = Integer.parseInt(hm.get("count").toString());
    	}

    	@Override
    	public int getCount() {
    		return listCount;
    	}

    	@Override
    	public Object getItem(int arg0) {
    		return arg0;
    	}

    	@Override
    	public long getItemId(int position) {
    		return position;
    	}

    	public HashMap<String, Bitmap> hmImg = new HashMap<String, Bitmap>();
    	
    	@Override
    	public View getView(int position, View convertView, ViewGroup parent) {
    		if (convertView == null) {
    			convertView = inflater.inflate(mListLayout, parent, false);
    		}

    		try {
    			if (hmImg.get("thumb[" + position + "]") == null) {
    				String urlstr = hm.get("thumb[" + position + "]");
    				URL url = new URL(urlstr);
    				URLConnection conn = url.openConnection();
    				conn.connect();
    				BufferedInputStream bis = new BufferedInputStream(conn
    						.getInputStream(), 512 * 1024);
    				Bitmap bm = BitmapFactory.decodeStream(bis);
    				bis.close();
    				hmImg.put("thumb[" + position + "]", bm);
    			}
    			if (hmImg.get("thumb[" + position + "]") != null) {
    				((ImageView) convertView.findViewById(R.id.imageView1))
    						.setImageBitmap(hmImg.get("thumb[" + position + "]"));
    			}
    		} catch (IOException e) { }
    		
    		((TextView) convertView.findViewById(R.id.textView1))
			.setText("["+hm.get("rowid["+position+"]") + "] " 
							+ hm.get("subject["+position+"]"));
			((TextView) convertView.findViewById(R.id.textView2))
			.setText(hm.get("content["+position+"]"));
			((TextView) convertView.findViewById(R.id.textView3))
			.setText(hm.get("writer["+position+"]"));
			
			final int positionInt = position;
			((LinearLayout) convertView.findViewById(R.id.linearLayout1))
			.setOnClickListener(new Button.OnClickListener() {
				public void onClick(View v) {
					detailInfo(positionInt);
				}
			});

    		return convertView;
    	}
    	
    	public void detailInfo(int position) {
    		Dialog dialog = new Dialog(mContext);
    		dialog.setContentView(R.layout.detail);
    		dialog.setTitle(hm.get("rowid["+position+"]"));
    		dialog.show();
    		
    		((TextView) dialog.findViewById(R.id.textView1))
					.setText(hm.get("subject[" + position + "]"));
			((TextView) dialog.findViewById(R.id.textView2))
					.setText(hm.get("writer[" + position + "]"));
			((TextView) dialog.findViewById(R.id.textView3))
					.setText(hm.get("content[" + position + "]"));
			
			Button buttonOK = (Button) dialog.findViewById(R.id.button1);
    		buttonOK.setOnClickListener(new detailOKListener(dialog));
    		
			try {
				if (hm.get("img[" + position + "]") != null) {
					String urlstr = hm.get("img[" + position + "]");
					URL url = new URL(urlstr);
					URLConnection conn = url.openConnection();
					conn.connect();
					BufferedInputStream bis = new BufferedInputStream(conn
							.getInputStream(), 512 * 1024);
					Bitmap bm = BitmapFactory.decodeStream(bis);
					((ImageView) dialog.findViewById(R.id.imageView1))
						.setImageBitmap(bm);
					bis.close();
				}
			} catch (IOException e) { }
    		
    	}

    	protected class detailOKListener implements OnClickListener {
    		private Dialog dialog;
    		public detailOKListener(Dialog dialog) {
    			this.dialog = dialog;
    		}
    		public void onClick(View v) {
    			dialog.dismiss();
    		}
    	}

    }
}