package com.owl.sample;

import java.io.IOException;

import android.app.Activity;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnPreparedListener;
import android.os.Bundle;
import android.view.MotionEvent;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.Toast;

public class MediaControllerActivity extends Activity implements
		OnPreparedListener, MediaController.MediaPlayerControl {

	private MediaPlayer mediaPlayer;
	private MediaController mediaController;
	private String audioFile;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		audioFile = this.getIntent().getStringExtra("audioPath");
		audioFile = "http://www.owllab.com/android/basic/mp30.mp3";
		((TextView) findViewById(R.id.textView1)).setText(audioFile);
		mediaPlayer = new MediaPlayer();
		mediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
		mediaPlayer.setOnPreparedListener(this);

		try {
			mediaPlayer.setDataSource(audioFile);
			mediaPlayer.prepare();
			// mediaPlayer.start();
		} catch (IOException e) {
			Toast.makeText(this, e.toString(), Toast.LENGTH_LONG).show();
		}

	}

	public void onPrepared(MediaPlayer mediaPlayer) {
		mediaController = new MediaController(this);
		mediaController.setMediaPlayer(this);
		mediaController.setAnchorView((MediaController) findViewById(R.id.mediaController1));
	}

	@Override
	protected void onStop() {
		super.onStop();
		mediaPlayer.stop();
		mediaPlayer.release();
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		mediaController.show(0);
		return true;
	}

	@Override
	public boolean canPause() {
		return true;
	}

	@Override
	public boolean canSeekBackward() {
		return true;
	}

	@Override
	public boolean canSeekForward() {
		return true;
	}

	@Override
	public int getBufferPercentage() {
		return 0;
	}

	@Override
	public int getCurrentPosition() {
		return mediaPlayer.getCurrentPosition();
	}

	@Override
	public int getDuration() {
		return mediaPlayer.getDuration();
	}

	@Override
	public boolean isPlaying() {
		return mediaPlayer.isPlaying();
	}

	@Override
	public void pause() {
		mediaPlayer.pause();
	}

	@Override
	public void seekTo(int pos) {
		mediaPlayer.seekTo(pos);
	}

	@Override
	public void start() {
		mediaPlayer.start();
	}

}