package com.owl.sample;

import java.io.File;

import android.app.Activity;
import android.content.Intent;
import android.gesture.GestureLibraries;
import android.gesture.GestureLibrary;
import android.gesture.GestureOverlayView;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

public class GestureOverlayViewActivity extends Activity {
    
	Activity act = this;
	GestureOverlayView gov;
	ImageView imageView;
	private static GestureLibrary gestLib;
	private final File gestFile = new File(Environment.getExternalStorageDirectory(), "gestureData");

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        if (gestLib==null) {
        	gestLib = GestureLibraries.fromFile(gestFile);
        	gestLib.load();
        }
        gov = (GestureOverlayView) findViewById(R.id.gestureOverlayView1);
//        gov.addOnGestureListener(new gestureListener());
        imageView = (ImageView) findViewById(R.id.imageView1);
        intButton();
    }

    public void intButton() {
    	findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						gov.setFadeOffset(100);
						gov.clear(true);
						gov.setFadeOffset(10000);
						imageView.setBackgroundDrawable(act.getResources().getDrawable(R.drawable.blank));
					}
				});

		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						if (gov.getGesture()!=null) {
							gestLib.addGesture("gesture", gov.getGesture());
							gestLib.save();
						}
					}
				});
		
		findViewById(R.id.button3).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Intent intent = new Intent(act, GalleryActivity.class);
						startActivity(intent);
					}
				});
    }
    
    
//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        Gesture gesture = gov.getGesture();
//        outState.putParcelable("gesture", (Parcelable) gesture);
//        super.onSaveInstanceState(outState);
//    }
//
//    @Override
//    protected void onRestoreInstanceState(Bundle savedInstanceState) {
//        Gesture gesture = (Gesture) savedInstanceState.getParcelable("gesture");
//        gov.setGesture(gesture);
//        super.onRestoreInstanceState(savedInstanceState);
//    }
//    
//    private class gestureListener implements GestureOverlayView.OnGestureListener {
//        public void onGestureStarted(GestureOverlayView overlay, MotionEvent event) { }
//        public void onGesture(GestureOverlayView overlay, MotionEvent event) { }
//        public void onGestureEnded(GestureOverlayView overlay, MotionEvent event) { }
//        public void onGestureCancelled(GestureOverlayView overlay, MotionEvent event) { }
//    }
    
}