package com.owl.sample;

import java.util.ArrayList;
import java.util.List;
import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Bundle;
import android.util.FloatMath;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnTouchListener;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Gallery;
import android.widget.ImageView;
import android.widget.AdapterView.OnItemClickListener;

public class GalleryActivity extends Activity implements OnTouchListener {

	// Integer[] galleryIda = { R.drawable.p1, R.drawable.p2, R.drawable.p3,
	// R.drawable.p4, R.drawable.p5, R.drawable.p6, R.drawable.p7,
	// R.drawable.p8, R.drawable.p9 };

	List<Integer> galleryIda = new ArrayList<Integer>();

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		for (int i = 1; i < 10; i++) {
			galleryIda.add(getResources().getIdentifier("p" + i, "drawable",
					this.getPackageName()));
		}

		final ImageView iv1 = (ImageView) findViewById(R.id.imageView1);

		Gallery g = (Gallery) findViewById(R.id.gallery1);
		g.setAdapter(new galleryAdapter(this));
		g.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View v,
					int position, long id) {
				iv1.setImageResource(galleryIda.get(position));
			}

		});

		iv1.setImageResource(galleryIda.get(0));
		iv1.setOnTouchListener(this);

	}

	public class galleryAdapter extends BaseAdapter {

		private final Context mContext;
		LayoutInflater inflater;

		public galleryAdapter(Context c) {
			mContext = c;
			inflater = (LayoutInflater) mContext
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		public int getCount() {
			return galleryIda.size();
		}

		public Object getItem(int position) {
			return position;
		}

		public long getItemId(int position) {
			return position;
		}

		public View getView(int position, View convertView, ViewGroup parent) {
			if (convertView == null) {
				convertView = inflater.inflate(R.layout.gallery_item, parent,
						false);
			}
			ImageView imageView = (ImageView) convertView
					.findViewById(R.id.imageView1);
			imageView.setImageResource(galleryIda.get(position));
			return convertView;
		}
	}

	// //ZoomTouch////////////////////////
	int touchNum = 0;
	float orgScale = 1f;
	PointF startPoint = new PointF();
	PointF midPoint = new PointF();
	Matrix targetMatrix = new Matrix();
	Matrix savedMatrix = new Matrix();

	@Override
	public boolean onTouch(View v, MotionEvent event) {

		ImageView view = (ImageView) v;
		view.setScaleType(ImageView.ScaleType.MATRIX);

		float targetScale;

		switch (event.getAction() & MotionEvent.ACTION_MASK) {
		case MotionEvent.ACTION_DOWN:
			savedMatrix.set(targetMatrix);
			startPoint.set(event.getX(), event.getY());
			touchNum = 1;
			break;
		case MotionEvent.ACTION_UP:
		case MotionEvent.ACTION_POINTER_UP:
			touchNum = 0;
			break;
		case MotionEvent.ACTION_POINTER_DOWN:
			orgScale = Diagonal(event);
			if (orgScale > 5f) {
				savedMatrix.set(targetMatrix);
				MidPoint(midPoint, event);
				touchNum = 2;
			}
			break;
		case MotionEvent.ACTION_MOVE:
			if (touchNum == 1) {
				targetMatrix.set(savedMatrix);
				if (view.getLeft() >= -392) {
					targetMatrix.postTranslate(event.getX() - startPoint.x,
							event.getY() - startPoint.y);
				}
			} else if (touchNum == 2) {
				float scaleNew = Diagonal(event);
				if (scaleNew > 5f) {
					targetMatrix.set(savedMatrix);
					targetScale = scaleNew / orgScale;
					targetMatrix.postScale(targetScale, targetScale,
							midPoint.x, midPoint.y);
				}
			}
			break;
		}

		view.setImageMatrix(targetMatrix);

		return true;
	}

	private float Diagonal(MotionEvent event) {
		float x = event.getX(0) - event.getX(1);
		float y = event.getY(0) - event.getY(1);
		return FloatMath.sqrt(x * x + y * y);
	}

	private void MidPoint(PointF point, MotionEvent event) {
		float x = event.getX(0) + event.getX(1);
		float y = event.getY(0) + event.getY(1);
		point.set(x / 2, y / 2);
	}
}