package com.owl.sample;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

public class ButtonActivity extends Activity {
	Activity act = this;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		findViewById(R.id.button1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act.getBaseContext(), "첫번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
			}
		});

		findViewById(R.id.button2).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act, "두번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
			}
		});

		findViewById(R.id.button3).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act, "세번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
				Uri uri = Uri.parse("smsto:5554");
				Intent intent = new Intent(Intent.ACTION_SENDTO, uri);
				intent.putExtra("sms_body", "문의합니다.");
				act.startActivity(intent);
			}
		});

		findViewById(R.id.button4).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act, "네번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
				Intent intent = new Intent(Intent.ACTION_VIEW, 
						Uri.parse("http://www.owllab.com"));
				act.startActivity(intent);
			}
		});

		findViewById(R.id.button5).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act, "다섯번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
				Intent intent = new Intent(Intent.ACTION_DIAL, 
						Uri.parse("tel:01012345789"));
				act.startActivity(intent);
			}
		});

		findViewById(R.id.button6).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act, "여섯번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
				Uri uri = Uri.parse("geo:37.5,127");
				Intent intent = new Intent(Intent.ACTION_VIEW, uri);
				act.startActivity(intent);
			}
		});

		findViewById(R.id.button7).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				Toast.makeText(act, "일곱번째 버튼을 클릭했습니다.", 
						Toast.LENGTH_LONG).show();
				Intent intent = new Intent(Intent.ACTION_VIEW, 
						Uri.parse("content://contacts/people/"));
				act.startActivity(intent);
			}
		});

	}
}