package com.owl.sample;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

public class RequestFocusActivity extends Activity {
	Activity act = this;
	List<Integer> idList = new ArrayList<Integer>();
	int t = 0;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        for (int i = 1; i < 100; i++) {
			int res = getResources().getIdentifier("editText" + i, "id", getPackageName());
			if (res <= 0) break;
			idList.add(getResources().getIdentifier("editText" + i, "id", getPackageName()));
		}

        findViewById(R.id.button1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				t = findFocused();
				t--;
				if (t < 0) t = idList.size() - 1;
				findViewById(idList.get(t)).requestFocus();
			}
		});

		findViewById(R.id.button2).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				t = findFocused();
				t++;
				if (t > idList.size() - 1) t = 0;
				findViewById(idList.get(t)).requestFocus();
			}
		});
    }
    
    public Integer findFocused() {
    	Integer focused = 0;
    	for (int i = 0; i < idList.size(); i++) {
    		if (findViewById(idList.get(i)).isFocused()) {
    			focused = i;
    			break;
    		}
    	}
    	return focused;
    }
}