package com.owl.sample;

import android.app.Activity;
import android.graphics.PointF;
import android.os.Bundle;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ViewFlipper;
import android.widget.FrameLayout.LayoutParams;

public class ViewFlipperActivity extends Activity implements OnTouchListener {
	
	private ViewFlipper vf;
	Button btn1;
	private Animation leftIn;
	private Animation leftOut;
	private Animation rightIn;
	private Animation rightOut;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        vf = (ViewFlipper) findViewById(R.id.viewFlipper1);
        
        for (int i = 4; i < 100; i++) {
        	int res = getResources().getIdentifier("p" + i, "drawable",
					this.getPackageName());
        	if (res<=0) break;
        	ImageView iv = new ImageView(this);
        	iv.setImageResource(res);
        	vf.addView(iv,i-1);
		}

        vf.setOnTouchListener(this);

        leftIn = AnimationUtils.loadAnimation(this,R.anim.left_in);
        leftOut = AnimationUtils.loadAnimation(this,R.anim.left_out);
        rightIn = AnimationUtils.loadAnimation(this,R.anim.right_in);
        rightOut = AnimationUtils.loadAnimation(this,R.anim.right_out);
        
        btn1 = (Button) findViewById(R.id.button1);
        btn1.setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						slideStart();
					}
				});
    }
    
    public void slideLeft() {
    	vf.setInAnimation(leftIn);
    	vf.setOutAnimation(leftOut);
    	vf.showNext();
    }
    
    public void slideRight() {
    	vf.setInAnimation(rightIn);
    	vf.setOutAnimation(rightOut);
    	vf.showPrevious();
    }
    
    public void slideStart() {
    	btn1.setVisibility(View.INVISIBLE);
    	vf.setInAnimation(leftIn);
    	vf.setOutAnimation(leftOut);
    	vf.startFlipping();
    }
    
    PointF startPoint = new PointF();
	int gap = 0;
	int preGap = 0;
	
	@Override
	public boolean onTouch(View v, MotionEvent event) {
		LayoutParams par = (LayoutParams) vf.getLayoutParams();
		switch (event.getAction() & MotionEvent.ACTION_MASK) {
		case MotionEvent.ACTION_DOWN:
			vf.stopFlipping();
			startPoint.set(event.getX(), event.getY());
			break;
		case MotionEvent.ACTION_UP:
			preGap = (int) (event.getX() - startPoint.x);
			if (Math.abs(preGap)>80) {
				if (preGap > 0) slideRight();
				else slideLeft();
				if (!btn1.isShown()) slideStart();
			} else {
				btn1.setVisibility(View.VISIBLE);
				vf.stopFlipping();
			}
			gap = 0;
			break;
		case MotionEvent.ACTION_MOVE:
			preGap = (int) (event.getX() - startPoint.x);
			if (preGap >= 0)  {
				if (preGap >= gap) gap = preGap;
			} else {
				if (preGap <= gap) gap = preGap;
			}
			break;
		}
		par.gravity = Gravity.TOP;
		par.rightMargin = gap * (-1);
		par.leftMargin = gap;
		v.setLayoutParams(par);

		return true;
	}
}