package com.owl.sample;

import java.util.ArrayList;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.MotionEvent;
import android.view.View;

public class CustomView extends View {

	Path path;
	private ArrayList<Path> graphics = new ArrayList<Path>();
	private Paint pen;

	public CustomView(Context context) {
		super(context);
		pen = new Paint();
		pen.setDither(true);
		pen.setColor(Color.BLACK);
		pen.setStyle(Paint.Style.STROKE);
		pen.setStrokeJoin(Paint.Join.ROUND);
		pen.setStrokeCap(Paint.Cap.ROUND);
		pen.setStrokeWidth(10);
	}
	
	@Override
	protected void onFinishInflate() {
		setFocusable(true);
		setFocusableInTouchMode(true);
	}

	@Override
	public void onDraw(Canvas canvas) {
		for (Path path1 : graphics) {
			canvas.drawPath(path1, pen);
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		switch (event.getAction()) {
		case MotionEvent.ACTION_DOWN:
			path = new Path();
			path.moveTo(event.getX(), event.getY());
			path.lineTo(event.getX(), event.getY());
			break;
		case MotionEvent.ACTION_UP:
			path.lineTo(event.getX(), event.getY());
			graphics.add(path);
			break;
		case MotionEvent.ACTION_MOVE:
			path.lineTo(event.getX(), event.getY());
			path.moveTo(event.getX(), event.getY());
			graphics.add(path);
			break;
		}
		invalidate();
		return true;
	}

	public void clearCanvas() {
		graphics.clear();
		invalidate();
	}
}
