package com.owl.sample;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TwoLineListItem;

public class listAdapter extends BaseAdapter {

	LayoutInflater inflater;
	Context cont;
	public int listCount = 0;
	String[] subjecta;
	String[] briefa;
	List<Integer> thumba = new ArrayList<Integer>();

	public listAdapter(Context tContext) {
		cont = tContext;
		inflater = (LayoutInflater) cont
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		subjecta = cont.getResources().getStringArray(R.array.subject);
		briefa = cont.getResources().getStringArray(R.array.brief);
		
		for (int i = 0; i < subjecta.length; i++) {
			thumba.add(cont.getResources().getIdentifier("thumb" + i, "drawable",
					cont.getPackageName()));
		}

		if (subjecta != null) {
			listCount = subjecta.length;
		}
	}

	@Override
	public int getCount() {
		// TODO Auto-generated method stub
		return listCount;
	}

	@Override
	public Object getItem(int arg0) {
		// TODO Auto-generated method stub
		return arg0;
	}

	@Override
	public long getItemId(int position) {
		// TODO Auto-generated method stub
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = (View) inflater.inflate(R.layout.list_row, parent,
					false);
		}

		TwoLineListItem tl = (TwoLineListItem) convertView
				.findViewById(R.id.TwoLineListItem1);
		if (tl.getText1() != null)
			tl.getText1().setText(subjecta[position]);
		if (tl.getText2() != null)
			tl.getText2().setText(briefa[position]);

		ImageView iv = (ImageView) convertView.findViewById(R.id.imageView1);
		iv.setImageDrawable(cont.getResources().getDrawable(thumba.get(position)));

		return convertView;
	}
}
