package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.ScrollView;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;

public class TextSwitcherActivity extends Activity implements
		ViewSwitcher.ViewFactory {

	private TextSwitcher ts;
	private ScrollView sv;
	private String[] texta;
	private int t = 0;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		texta = getResources().getStringArray(R.array.receipes);

		sv = (ScrollView) findViewById(R.id.scrollView1);
		ts = (TextSwitcher) findViewById(R.id.textSwitcher1);
		ts.setFactory(this);
		ts.setText(texta[0]);
		
		// Animation in = AnimationUtils.loadAnimation(this,
		// android.R.anim.fade_in);
		// Animation out = AnimationUtils.loadAnimation(this,
		// android.R.anim.fade_out);
		// ts.setInAnimation(in);
		// ts.setOutAnimation(out);

		findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						t--;
						if (t < 0)
							t = 0;
						ts.setText(texta[t]);
						sv.smoothScrollTo(0, 0);
					}
				});

		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						t++;
						if (t > texta.length - 1)
							t = texta.length - 1;
						ts.setText(texta[t]);
						sv.smoothScrollTo(0, 0);
					}
				});

	}

	@Override
	public View makeView() {
		TextView t = new TextView(this);
		t.setGravity(Gravity.TOP | Gravity.LEFT);
		t.setTextSize(26);
		return t;
	}
}