package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

public class SpinnerActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		String[] optionLavala = getResources().getStringArray(
				R.array.spinnerArray1);
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_item, optionLavala);
		Spinner obj = (Spinner) findViewById(R.id.spinner1);
		obj.setAdapter(adapter);

		setSpinner(R.id.spinner2, R.array.spinnerArray2,
				android.R.layout.simple_spinner_dropdown_item);
		setSpinner(R.id.spinner3, R.array.spinnerArray3, R.layout.spinner_item);

		getSpinner(R.id.spinner1).setOnItemSelectedListener(
				new OnItemSelectedListener() {
					@Override
					public void onItemSelected(AdapterView<?> parentView,
							View selectedItemView, int position, long id) {
						printChecked(selectedItemView, position);
					}

					@Override
					public void onNothingSelected(AdapterView<?> parentView) {
					}
				});

		getSpinner(R.id.spinner2).setOnItemSelectedListener(
				new OnItemSelectedListener() {
					public void onItemSelected(AdapterView<?> parentView,
							View selectedItemView, int position, long id) {
						printChecked(selectedItemView, position);
					}

					public void onNothingSelected(AdapterView<?> parentView) {
					}
				});

		getSpinner(R.id.spinner3).setOnItemSelectedListener(
				new OnItemSelectedListener() {
					public void onItemSelected(AdapterView<?> parentView,
							View selectedItemView, int position, long id) {
						printChecked(selectedItemView, position);
					}

					public void onNothingSelected(AdapterView<?> parentView) {
					}
				});
	}

	public void printChecked(View v, int position) {
		Spinner sp1 = (Spinner) findViewById(R.id.spinner1);
		Spinner sp2 = (Spinner) findViewById(R.id.spinner2);
		Spinner sp3 = (Spinner) findViewById(R.id.spinner3);
		String resultText = "";
		if (sp1.getSelectedItemPosition() > 0) {
			resultText = (String) sp1.getAdapter().getItem(
					sp1.getSelectedItemPosition());
		}
		if (sp2.getSelectedItemPosition() > 0) {
			if (!"".equals(resultText))
				resultText += ", ";
			resultText += (String) sp2.getAdapter().getItem(
					sp2.getSelectedItemPosition());
		}
		if (sp3.getSelectedItemPosition() > 0) {
			if (!"".equals(resultText))
				resultText += ", ";
			resultText += (String) sp3.getAdapter().getItem(
					sp3.getSelectedItemPosition());
		}
		if (resultText != "") {
			((TextView) findViewById(R.id.textView2)).setText(resultText);
		}
	}

	public void setSpinner(int objId, int optionLabelId, int listStyle) {
		setSpinner(objId, optionLabelId, -1, listStyle, null);
	}

	public void setSpinner(int objId, int optionLabelId, int optionId,
			int listStyle, String defaultVal) {
		String[] optionLavala = getResources().getStringArray(optionLabelId);
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_item, optionLavala);

		if (listStyle > -1)
			adapter.setDropDownViewResource(listStyle);

		Spinner obj = (Spinner) findViewById(objId);
		obj.setAdapter(adapter);
		if (defaultVal != null) {
			if (optionId > 0) {
				String[] optiona = getResources().getStringArray(optionId);
				int thei = 0;
				for (int a = 0; a < optiona.length; a++) {
					if (defaultVal.equals(optiona[a])) {
						thei = a;
						break;
					}
				}
				obj.setSelection(adapter.getPosition(optionLavala[thei]));
			} else {
				obj.setSelection(adapter.getPosition(defaultVal));
			}
		}
	}

	public Spinner getSpinner(int objId) {
		return (Spinner) findViewById(objId);
	}

	public String getSpinnerVal(int objId) {
		return getSpinnerVal(objId, null);
	}

	public String getSpinnerVal(int objId, String[] optiona) {
		String rtn = "";
		Spinner sp = ((Spinner) findViewById(objId));
		if (sp != null) {
			int selectedIndex = sp.getSelectedItemPosition();
			if (optiona == null) {
				rtn = "" + selectedIndex;
			} else {
				if (optiona.length > selectedIndex) {
					rtn = optiona[selectedIndex];
				}
			}
		}
		return rtn;
	}
}