package com.owl.sample;

import java.util.Random;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.widget.Toast;

public class MSGService extends Service {

	static final int MSG_WHAT_RANDOM = 1;
	final Messenger msgr = new Messenger(new MSGHandler());
	
	@Override
	public IBinder onBind(Intent intent) {
		String startMsg = "서비스 준비가 완료되었습니다.";
		Toast.makeText(getApplicationContext(), startMsg, Toast.LENGTH_SHORT).show();
		return msgr.getBinder();
	}
	
	class MSGHandler extends Handler {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_WHAT_RANDOM:
                	String msgString = "행운의 번호는 \"" + getLuckNum() + "\" 입니다.";
                    Toast.makeText(getApplicationContext(), msgString, Toast.LENGTH_SHORT).show();
                    break;
                default:
                    super.handleMessage(msg);
            }
        }
    }

	public int getLuckNum() {
		Random random = new Random();
		int tmpi = random.nextInt(45) + 1;
		return tmpi;
	}
}
