package com.owl.sample;

import java.util.List;

import android.app.Activity;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.TextView;

public class SearchViewActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		getWindow().requestFeature(Window.FEATURE_ACTION_BAR);
		setContentView(R.layout.main);
		initSearchView();
	}

	private SearchView searchView;
	private ListView listView;
	private PackageManager pm;
	private List<ResolveInfo> appsOrg;
	private List<ResolveInfo> apps;

	private void initSearchView() {
		Intent mainIntent = new Intent(Intent.ACTION_MAIN, null);
		mainIntent.addCategory(Intent.CATEGORY_LAUNCHER);
		pm = getPackageManager();
		appsOrg = pm.queryIntentActivities(mainIntent, 0);
		apps = pm.queryIntentActivities(mainIntent, 0);

		listView = (ListView) findViewById(R.id.listView1);
		listAdapter listAdapter = new listAdapter();
		listView.setAdapter(listAdapter);
		listView.setTextFilterEnabled(true);

		searchView = (SearchView) findViewById(R.id.searchView1);
		searchView.setIconifiedByDefault(false);
		searchView.setSubmitButtonEnabled(false);
		searchView.setQueryHint(getString(R.string.search_hint));

		searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
			public boolean onQueryTextChange(String newText) {
				return false;
			}

			public boolean onQueryTextSubmit(String query) {
				if (TextUtils.isEmpty(query)) {
					apps.clear();
					apps.addAll(appsOrg);
				} else {
					apps.clear();
					for (ResolveInfo info : appsOrg) {
						if (info.activityInfo.loadLabel(pm).toString()
								.toLowerCase().indexOf(
										query.toString().toLowerCase()) >= 0) {
							apps.add(info);
						}
					}
				}
				listView.setAdapter(new listAdapter());
				return false;
			}
		});
		searchView.setOnCloseListener(new SearchView.OnCloseListener() {
			public boolean onClose() {
				apps.clear();
				apps.addAll(appsOrg);
				listView.setAdapter(new listAdapter());
				return false;
			}
		});

	}

	Activity act = this;

	public class listAdapter extends BaseAdapter {
		LayoutInflater inflater;

		public listAdapter() {
			inflater = (LayoutInflater) act
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		public final int getCount() {
			return apps.size();
		}

		public final Object getItem(int position) {
			return apps.get(position);
		}

		public final long getItemId(int position) {
			return position;
		}

		public View getView(int position, View convertView, ViewGroup parent) {

			if (convertView == null) {
				convertView = inflater.inflate(
						android.R.layout.simple_expandable_list_item_1, parent,
						false);
			}

			final ResolveInfo info = apps.get(position);

			TextView textView = (TextView) convertView
					.findViewById(android.R.id.text1);
			Spanned html = Html.fromHtml("<img src=\"icon\">&nbsp;&nbsp;"
					+ info.activityInfo.loadLabel(pm).toString(),
					new ImageGetter(info.activityInfo
							.loadIcon(getPackageManager())), null);
			textView.setGravity(Gravity.CENTER_VERTICAL);
			textView.setText(html);

			textView.setOnClickListener(new Button.OnClickListener() {
				public void onClick(View v) {
					Intent intent = new Intent(Intent.ACTION_RUN);
					intent.setComponent(new ComponentName(
							info.activityInfo.packageName,
							info.activityInfo.name));
					act.startActivity(intent);
				}
			});

			return convertView;
		}
	}

	public class ImageGetter implements Html.ImageGetter {

		private Drawable dw;

		public ImageGetter(Drawable dwTmp) {
			dw = dwTmp;
		}

		public Drawable getDrawable(String source) {
			dw.setBounds(0, 0, dw.getIntrinsicWidth(), dw.getIntrinsicHeight());
			return dw;
		}
	}
	
	
	private SearchView topSearchView;

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);

		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.searchview_top, menu);
		topSearchView = (SearchView) menu.findItem(R.id.searchViewitem)
				.getActionView();
		initTopSearchView();

		return true;
	}

	private void initTopSearchView() {

		topSearchView.setIconifiedByDefault(true);
		SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);
		if (searchManager != null) {
			List<SearchableInfo> appList = searchManager
					.getSearchablesInGlobalSearch();
			SearchableInfo appInfo = searchManager
					.getSearchableInfo(getComponentName());
			for (SearchableInfo inf : appList) {
				if (inf.getSuggestAuthority() != null
						&& inf.getSuggestAuthority().startsWith("applications")) {
					appInfo = inf;
				}
			}
			topSearchView.setSearchableInfo(appInfo);
		}

		topSearchView
				.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
					public boolean onQueryTextChange(String newText) {
						return false;
					}

					public boolean onQueryTextSubmit(String query) {
						return false;
					}
				});
		topSearchView.setOnCloseListener(new SearchView.OnCloseListener() {
			public boolean onClose() {
				return false;
			}
		});
	}

}
