package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.TextView;

public class RadioButtonActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		findViewById(R.id.radioButton1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				printChecked(v);
			}
		});
		findViewById(R.id.radioButton2).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				printChecked(v);
			}
		});
	}

	public void printChecked(View v) {
		RadioButton rb1 = (RadioButton) findViewById(R.id.radioButton1);
		RadioButton rb2 = (RadioButton) findViewById(R.id.radioButton2);
		String resultText = "";
		if (rb1.isChecked()) {
			resultText = rb1.getText().toString();
		}
		if (rb2.isChecked()) {
			if (!"".equals(resultText))
				resultText += ", ";
			resultText += rb2.getText().toString();
		}
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(resultText);
	}
}