package com.owl.sample;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.view.View;

import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;

public class QRCodeActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	public void gotoCapture(View view) {
		IntentIntegrator.initiateScan(this);
	}

	Activity act = this;
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		final IntentResult result = IntentIntegrator.parseActivityResult(requestCode,
				resultCode, data);
		new AlertDialog.Builder(this).setTitle("바코드 스캔 완료!!")
		.setMessage(
				" 바코드 번호 : " + result.getContents() 
				+"\n바코드 정보를 연결하시겠습니까?")
				.setPositiveButton("연결합니다.", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						TelephonyManager mTelephonyMgr;
						mTelephonyMgr = (TelephonyManager) act
								.getSystemService(Context.TELEPHONY_SERVICE);
						String myNum = mTelephonyMgr.getLine1Number();
						String url = "http://www.owllab.com/android2/barcodeInfo.php?code="
							+ result.getContents()
							+ "&phone="+myNum;
						gotoWeb(url);
					}
				})
				.setNegativeButton("취소", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
					}
				})
				.show();
	}
	
	public void gotoWeb(String destinationAddress) {
		Uri uri = Uri.parse(destinationAddress);
		Intent intent = new Intent(Intent.ACTION_VIEW, uri);
		startActivity(intent);
	}
}