package com.owl.sample;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.ToggleButton;

public class ProgressBarActivity extends Activity {

	public Activity act = this;
	public ProgressBar pb1;
	public ProgressBar pb2;
	public ToggleButton tb1;
	public ToggleButton tb2;
	public Button btn1;
	public Button btn2;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		pb1 = (ProgressBar) findViewById(R.id.progressBar1);
		pb2 = (ProgressBar) findViewById(R.id.progressBar2);
		pb1.setVisibility(ProgressBar.GONE);
		pb2.setVisibility(ProgressBar.GONE);

		tb1 = (ToggleButton) findViewById(R.id.toggleButton1);
		tb2 = (ToggleButton) findViewById(R.id.toggleButton2);

		tb1.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				if (((ToggleButton) v).isChecked()) {
					pb1.setVisibility(ProgressBar.VISIBLE);
				} else {
					pb1.setVisibility(ProgressBar.GONE);
				}
			}
		});

		tb2.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				if (((ToggleButton) v).isChecked()) {
					pb2.setVisibility(ProgressBar.VISIBLE);
					startProgressBarThread();
				} else {
					pb2.setVisibility(ProgressBar.GONE);
					stopProgressBarThread();
				}
			}
		});

		btn1 = (Button) findViewById(R.id.button1);
		btn2 = (Button) findViewById(R.id.button2);

		btn1.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				startLoading(act);
				endLoading();
			}
		});

		btn2.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				startProgressBarThread2();
			}

		});
	}

	// 막대형 진행바////////////////////////
	private volatile Thread theProgressBarThread1;
	public int CurrentPosition = 0;

	public synchronized void startProgressBarThread() {
		if (theProgressBarThread1 == null) {
			theProgressBarThread1 = new Thread(null, backgroundTread1,
					"startProgressBarThread");
			CurrentPosition = 0;
			theProgressBarThread1.start();
		}
	}

	public synchronized void stopProgressBarThread() {
		if (theProgressBarThread1 != null) {
			Thread tmpThread = theProgressBarThread1;
			theProgressBarThread1 = null;
			tmpThread.interrupt();
		}
		pb2.setVisibility(ProgressBar.GONE);
		tb2.setChecked(false);
		tb2.invalidate();
	}

	private Runnable backgroundTread1 = new Runnable() {
		@Override
		public void run() {
			if (Thread.currentThread() == theProgressBarThread1) {
				CurrentPosition = 0;
				final int total = 100;
				while (CurrentPosition < total) {
					try {
						progressBarHandle.sendMessage(progressBarHandle
								.obtainMessage());
						Thread.sleep(100);

					} catch (final InterruptedException e) {
						return;
					} catch (final Exception e) {
						return;
					}

				}
			}
		}

		Handler progressBarHandle = new Handler() {
			@Override
			public void handleMessage(Message msg) {
				CurrentPosition++;
				pb2.setProgress(CurrentPosition);
				tb2.setText("" + CurrentPosition + "%");
				if (CurrentPosition == 100) {
					stopProgressBarThread();
				}
			}
		};
	};

	// 원형 진행상자////////////////////////
	public ProgressDialog loadingDialog;

	public void startLoading(Context ctx) {
		if (loadingDialog == null) {
			loadingDialog = ProgressDialog.show(ctx, "Loading...",
					"Please wait...", false, true);
		}
	}

	public void endLoading() {
		endLoader endLoader = new endLoader();
		Timer timer = new Timer(false);
		timer.schedule(endLoader, 5000);
	}

	class endLoader extends TimerTask {
		endLoader() {
		}

		public void run() {
			if (loadingDialog != null) {
				loadingDialog.dismiss();
				loadingDialog = null;
			}
		}
	}

	// 막대형 진행상자//////////////////////////
	public ProgressDialog progressDialog;
	private volatile Thread theProgressBarThread2;
	public int CurrentPosition2 = 0;
	
	public synchronized void startProgressBarThread2() {
		if (theProgressBarThread2 == null) {
			theProgressBarThread2 = new Thread(null, backgroundTread2,
					"startProgressBarThread2");
			CurrentPosition2 = 0;
			theProgressBarThread2.start();

			progressDialog = new ProgressDialog(act);
			progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
			progressDialog.setMessage("OWL DRM Certificating ...");
			progressDialog.incrementProgressBy(1);
			progressDialog.setMax(100);
			progressDialog.setProgress(0);
			progressDialog.show();
		}
	}

	public synchronized void stopProgressBarThread2() {
		if (theProgressBarThread2 != null) {
			Thread tmpThread = theProgressBarThread2;
			theProgressBarThread2 = null;
			tmpThread.interrupt();
		}
		if (progressDialog != null)
			progressDialog.dismiss();
	}

	private Runnable backgroundTread2 = new Runnable() {
		@Override
		public void run() {
			if (Thread.currentThread() == theProgressBarThread2) {
				CurrentPosition2 = 0;
				final int total = 100;
				while (CurrentPosition2 < total) {
					try {
						progressBarHandle2.sendMessage(progressBarHandle2
								.obtainMessage());
						Thread.sleep(100);

					} catch (final InterruptedException e) {
						return;
					} catch (final Exception e) {
						return;
					}

				}
			}
		}

		Handler progressBarHandle2 = new Handler() {
			@Override
			public void handleMessage(Message msg) {
				CurrentPosition2++;
				progressDialog.setProgress(CurrentPosition2);
				progressDialog.setMessage("OWL DRM Certificating ..."
						+ CurrentPosition2 + "%");
				if (CurrentPosition2 == 100) {
					stopProgressBarThread2();
				}
			}
		};
	};

}