package com.owl.sample;

import android.app.Activity;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.FloatMath;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.ImageView;

public class DetailViewActivity extends Activity implements OnTouchListener {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.tmp);
		ImageView iv1 = (ImageView) this.findViewById(R.id.imageView1);
		Drawable dw = this.getResources().getDrawable(
				this.getIntent().getIntExtra("Rid", 0));
		iv1.setImageDrawable(dw);
		iv1.setScaleType(ImageView.ScaleType.FIT_CENTER);
		iv1.setOnTouchListener(this);
	}

	int touchNum = 0;
	float orgScale = 1f;
	PointF startPoint = new PointF();
	PointF midPoint = new PointF();
	Matrix targetMatrix = new Matrix();
	Matrix savedMatrix = new Matrix();

	@Override
	public boolean onTouch(View v, MotionEvent event) {

		ImageView view = (ImageView) v;
		view.setScaleType(ImageView.ScaleType.MATRIX);

		float targetScale;

		switch (event.getAction() & MotionEvent.ACTION_MASK) {
		case MotionEvent.ACTION_DOWN:
			savedMatrix.set(targetMatrix);
			startPoint.set(event.getX(), event.getY());
			touchNum = 1;
			break;
		case MotionEvent.ACTION_UP:
		case MotionEvent.ACTION_POINTER_UP:
			touchNum = 0;
			break;
		case MotionEvent.ACTION_POINTER_DOWN:
			orgScale = Diagonal(event);
			if (orgScale > 5f) {
				savedMatrix.set(targetMatrix);
				MidPoint(midPoint, event);
				touchNum = 2;
			}
			break;
		case MotionEvent.ACTION_MOVE:
			if (touchNum == 1) {
				targetMatrix.set(savedMatrix);
				if (view.getLeft() >= -392) {
					targetMatrix.postTranslate(event.getX() - startPoint.x,
							event.getY() - startPoint.y);
				}
			} else if (touchNum == 2) {
				float scaleNew = Diagonal(event);
				if (scaleNew > 5f) {
					targetMatrix.set(savedMatrix);
					targetScale = scaleNew / orgScale;
					targetMatrix.postScale(targetScale, targetScale,
							midPoint.x, midPoint.y);
				}
			}
			break;
		}

		view.setImageMatrix(targetMatrix);

		return true;
	}

	private float Diagonal(MotionEvent event) {
		float x = event.getX(0) - event.getX(1);
		float y = event.getY(0) - event.getY(1);
		return FloatMath.sqrt(x * x + y * y);
	}

	private void MidPoint(PointF point, MotionEvent event) {
		float x = event.getX(0) + event.getX(1);
		float y = event.getY(0) + event.getY(1);
		point.set(x / 2, y / 2);
	}

}
