package com.owl.sample;

import java.util.List;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

public class GridViewActivity extends Activity {
	Activity act = this;
	GridView gridView;
	private List<ResolveInfo> apps;
	private PackageManager pm;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		Intent mainIntent = new Intent(Intent.ACTION_MAIN, null);
		mainIntent.addCategory(Intent.CATEGORY_LAUNCHER);

		pm = getPackageManager();
		apps = pm.queryIntentActivities(mainIntent, 0);

		setContentView(R.layout.main);

		gridView = (GridView) findViewById(R.id.gridView1);
		gridView.setAdapter(new gridAdapter());
	}

	public class gridAdapter extends BaseAdapter {
		LayoutInflater inflater;

		public gridAdapter() {
			inflater = (LayoutInflater) act
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		public final int getCount() {
			return apps.size();
		}

		public final Object getItem(int position) {
			return apps.get(position);
		}

		public final long getItemId(int position) {
			return position;
		}
		
		public View getView(int position, View convertView, ViewGroup parent) {

			if (convertView == null) {
				convertView = inflater.inflate(R.layout.grid_item, parent,
						false);
			}

			final ResolveInfo info = apps.get(position);

			ImageView imageView = (ImageView) convertView
					.findViewById(R.id.imageView1);
			TextView textView = (TextView) convertView
					.findViewById(R.id.textView1);
			imageView.setImageDrawable(info.activityInfo
					.loadIcon(getPackageManager()));
			textView.setText(info.activityInfo.loadLabel(pm).toString());

			Log.v("[Program]",info.activityInfo.packageName+","+
					info.activityInfo.name);
			
			imageView.setOnClickListener(new Button.OnClickListener() {
				public void onClick(View v) {
					Intent intent = new Intent(Intent.ACTION_RUN);
					intent.setComponent(new ComponentName(
							info.activityInfo.packageName,
							info.activityInfo.name));
					act.startActivity(intent);
					String msg = info.activityInfo.packageName + ", "
							+ info.activityInfo.name;
					Toast.makeText(act, msg, Toast.LENGTH_LONG).show();
				}
			});

			return convertView;
		}
	}
}
