package com.owl.sample;

import java.io.File;
import java.util.ArrayList;

import android.app.Activity;
import android.content.Context;
import android.gesture.Gesture;
import android.gesture.GestureLibraries;
import android.gesture.GestureLibrary;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Gallery;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.ViewSwitcher;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.LinearLayout.LayoutParams;

public class GalleryActivity extends Activity implements ViewSwitcher.ViewFactory {

	Activity act = this;
	private ImageSwitcher mSwitcher;
	private static GestureLibrary gestLib;
	private final File gestFile = new File(Environment.getExternalStorageDirectory(), "gestureData");
	ArrayList<Bitmap> bitmapList = new ArrayList<Bitmap>();
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.gallery);
		
		gestLib = GestureLibraries.fromFile(gestFile);
        if (gestLib.load()) {
            for (String name : gestLib.getGestureEntries()) {
                for (Gesture gesture : gestLib.getGestures(name)) {
                    final Bitmap bitmap = gesture.toBitmap(400, 400, 5, 0xffffffff);
                    bitmapList.add(bitmap);
                }
            }
        }

		mSwitcher = (ImageSwitcher) findViewById(R.id.imageSwitcher1);
		mSwitcher.setFactory(this);
		mSwitcher.setInAnimation(AnimationUtils.loadAnimation(this,
				android.R.anim.slide_in_left));
		mSwitcher.setOutAnimation(AnimationUtils.loadAnimation(this,
				android.R.anim.slide_out_right));
		
		Gallery gallery = (Gallery) findViewById(R.id.gallery1);
        gallery.setAdapter(new galleryAdapter(this));
		gallery.setOnItemSelectedListener(new OnItemSelectedListener() {
			@Override
			public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {
				if (v!=null) {
					Drawable drawable = new BitmapDrawable(bitmapList.get(position));
					mSwitcher.setImageDrawable(drawable);
					mSwitcher.setTag(""+position);
				}
			}
			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
			}
		});
	}
	
	@Override
	public View makeView() {
		ImageView iv1 = new ImageView(this);
		iv1.setBackgroundColor(0xFF000000);
		iv1.setScaleType(ImageView.ScaleType.FIT_CENTER);
		iv1.setLayoutParams(new ImageSwitcher.LayoutParams(
				LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
		return iv1;
	}

	public class galleryAdapter extends BaseAdapter {

		private final Context mContext;
		LayoutInflater inflater;

		public galleryAdapter(Context c) {
			mContext = c;
			inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		public int getCount() {
			return bitmapList.size();
		}

		public Object getItem(int position) {
			return position;
		}

		public long getItemId(int position) {
			return position;
		}

		public View getView(int position, View convertView, ViewGroup parent) {
			if (convertView == null) {
				convertView = inflater.inflate(R.layout.gallery_item, parent,
						false);
			}
			ImageView imageView = (ImageView) convertView.findViewById(R.id.imageView1);
			imageView.setImageDrawable(new BitmapDrawable(bitmapList.get(position)));
			imageView.setTag(""+position);
			return convertView;
		}
	}

}