package com.owl.sample;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseExpandableListAdapter;
import android.widget.Button;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.TextView;

public class ExpandableListViewActivity extends Activity {

	Activity act = this;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		ExpandableListView exlistView = 
			(ExpandableListView) findViewById(R.id.expandableListView1);
		ExpandableListAdapter exListAdapter = new expandableListAdapter();
		exlistView.setAdapter(exListAdapter);
	}

	public class expandableListAdapter extends BaseExpandableListAdapter {

		private String[] groups = getResources().getStringArray(
				R.array.category);

		public Object getGroup(int groupPosition) {
			return groups[groupPosition];
		}

		public int getGroupCount() {
			return groups.length;
		}

		public long getGroupId(int groupPosition) {
			return groupPosition;
		}

		public View getGroupView(int groupPosition, boolean isExpanded,
				View convertView, ViewGroup parent) {
			AbsListView.LayoutParams lp = new AbsListView.LayoutParams(
					ViewGroup.LayoutParams.FILL_PARENT, 90);
			TextView textView = new TextView(act);
			textView.setLayoutParams(lp);
			textView.setGravity(Gravity.CENTER_VERTICAL | Gravity.LEFT);
			textView.setPadding(60, 0, 0, 0);
			textView.setTextAppearance(getApplicationContext(),
					android.R.style.TextAppearance_Large);
			textView.setText(getGroup(groupPosition).toString());
			return textView;
		}
		
		public String[] getChildren(int groupPosition) {
			int resid = getResources().getIdentifier(groups[groupPosition],
					"array", getApplicationContext().getPackageName());
			String[] children = getResources().getStringArray(resid);
			return children;
		}

		public Object getChild(int groupPosition, int childPosition) {
			String[] children = getChildren(groupPosition);
			return children[childPosition];
		}

		public long getChildId(int groupPosition, int childPosition) {
			return childPosition;
		}

		public int getChildrenCount(int groupPosition) {
			String[] children = getChildren(groupPosition);
			int count = 0;
			if (children != null)
				count = children.length;
			return count;
		}

		public View getChildView(int groupPosition, int childPosition,
				boolean isLastChild, View convertView, ViewGroup parent) {

			AbsListView.LayoutParams lp = new AbsListView.LayoutParams(
					ViewGroup.LayoutParams.FILL_PARENT, 70);
			TextView textView = new TextView(act);
			textView.setLayoutParams(lp);
			textView.setGravity(Gravity.CENTER_VERTICAL | Gravity.LEFT);
			textView.setPadding(80, 0, 0, 0);
			textView.setTextAppearance(getApplicationContext(),
					android.R.style.TextAppearance_Medium);
			final String msg = getChild(groupPosition, childPosition)
					.toString();
			textView.setText(msg);

			textView.setOnClickListener(new Button.OnClickListener() {
				public void onClick(View v) {
					detailInfo(msg);
				}
			});

			return textView;
		}

		public void detailInfo(String msg) {
			AlertDialog.Builder detailPop = new AlertDialog.Builder(act);
			detailPop.setMessage(msg).setPositiveButton("닫기",
					new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.dismiss();
						}
					});
			AlertDialog alert = detailPop.create();
			alert.setTitle("상세정보");
			alert.setIcon(android.R.drawable.ic_search_category_default);
			alert.show();
		}

		public boolean isChildSelectable(int groupPosition, int childPosition) {
			return true;
		}

		public boolean hasStableIds() {
			return true;
		}

	}
}
