package com.owl.sample;

import java.text.DecimalFormat;

import android.app.Activity;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.widget.Button;
import android.widget.Chronometer;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ToggleButton;

public class ChronometerActivity extends Activity {
	Chronometer ct;
	TextView miliTextView;
	LinearLayout resultLayout;
	int num = 1;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        ct = (Chronometer) findViewById(R.id.chronometer1);
        miliTextView = (TextView) findViewById(R.id.textView1);
        resultLayout = (LinearLayout) findViewById(R.id.linearLayout1);
        
        final ToggleButton tb = (ToggleButton) findViewById(R.id.toggleButton1);

        tb.setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						if (tb.isChecked()) {
							ct.setBase(SystemClock.elapsedRealtime());
							ct.start();
							num=1;
						} else {
							ct.stop();
						}
					}
				});

		findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						markRecord();
					}
				});
		
		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						ct.setBase(SystemClock.elapsedRealtime());
						resultLayout.removeAllViews();
						num = 1;
					}
				});
		
		miliTextView.setText("");
		
		ct.setOnChronometerTickListener(new Chronometer.OnChronometerTickListener() {
	        @Override
	        public void onChronometerTick(Chronometer chronometer) {
	        	long elapsedMillis = SystemClock.elapsedRealtime() - ct.getBase(); 
	        	DecimalFormat numFormatter = new DecimalFormat("###,###");
	        	String output = numFormatter.format(elapsedMillis);
	            miliTextView.setText("Total MiliSec. : " + output);
	            
	        }
	    });
	}
    
    private void markRecord() {
    	long elapsedMillis = SystemClock.elapsedRealtime() - ct.getBase(); 
    	long seconds = ((int) elapsedMillis / 1000) * 1000 ;
       
        TextView recordView = new TextView(this);
        recordView.setTextAppearance(
				getApplicationContext(),
				android.R.style.TextAppearance_Large);
        recordView.setText("[" + num + "] " + ct.getText() + " " + (elapsedMillis-seconds));
        resultLayout.addView(recordView);
        num++;
    }
    
}