package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.TextView;

public class CheckedTextViewActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        findViewById(R.id.checkedTextView1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				printChecked(v);
			}
		});
        findViewById(R.id.checkedTextView2).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				printChecked(v);
			}
		});
    }
    
	public void printChecked(View v) {
		((CheckedTextView) v).toggle();
		CheckedTextView ch1 = (CheckedTextView) findViewById(R.id.checkedTextView1);
		CheckedTextView ch2 = (CheckedTextView) findViewById(R.id.checkedTextView2);
		String resultText = "";
		if (ch1.isChecked()) {
			resultText = ch1.getText().toString();
		}
		if (ch2.isChecked()) {
			if (!"".equals(resultText))
				resultText += ", ";
			resultText += ch2.getText().toString();
		}
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(resultText);
	}
}