package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;

public class CheckBoxActivity extends Activity {
	Activity act = this;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		findViewById(R.id.checkBox1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				printChecked(v);
			}
		});
		findViewById(R.id.checkBox2).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				printChecked(v);
			}
		});
	}

	public void printChecked(View v) {
		CheckBox ch1 = (CheckBox) findViewById(R.id.checkBox1);
		CheckBox ch2 = (CheckBox) findViewById(R.id.checkBox2);
		String resultText = "";
		if (ch1.isChecked()) {
			resultText = ch1.getText().toString();
		}
		if (ch2.isChecked()) {
			if (!"".equals(resultText))
				resultText += ", ";
			resultText += ch2.getText().toString();
		}
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(resultText);
	}
}