package com.owl.sample;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Intent;
import android.gesture.GestureOverlayView;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore.Images;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;

public class CaptureNPhotoGalleryActivity extends Activity {
	Activity act = this;
	ImageView iv;
	GestureOverlayView gov;
	RelativeLayout fl;
	LinearLayout ll;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		gov = (GestureOverlayView) findViewById(R.id.gestureOverlayView1);
		iv = (ImageView) findViewById(R.id.imageView1);
		fl = (RelativeLayout) findViewById(R.id.RelativeLayout1);
		ll = (LinearLayout) findViewById(R.id.linearLayout1);
		intButton();
	}

	public void intButton() {
		findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						long offsetOrg = gov.getFadeOffset();
						gov.setFadeOffset(100);
						gov.clear(true);
						gov.setFadeOffset(offsetOrg);
					}
				});

		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						ll.setVisibility(View.INVISIBLE);
						fl.buildDrawingCache();
						Bitmap captureView = fl.getDrawingCache();
						String path = Environment.getExternalStorageDirectory().toString()
								+ "/ScreenCapture/View" + nowdate() + ".jpg";
						FileOutputStream fos;
						try {
							fos = new FileOutputStream(path);
							captureView.compress(Bitmap.CompressFormat.JPEG, 100, fos);
							Toast.makeText(act, "Captured your Drawing !" + path, Toast.LENGTH_LONG).show();
							captureView = null; fos = null;
						} catch (FileNotFoundException e) {
							e.printStackTrace();
						}
						ll.setVisibility(View.VISIBLE);
						File savedFile = new File(path);
						ContentValues values = new ContentValues();
						values.put(Images.Media.DATA, savedFile.getAbsolutePath());
						values.put(Images.Media.TITLE, savedFile.getName());
						values.put(Images.Media.DISPLAY_NAME, savedFile.getName());
						values.put(Images.Media.BUCKET_ID, savedFile.getName());
						values.put(Images.Media.DESCRIPTION, savedFile.getName());
						FileNameMap fileNameMap = URLConnection.getFileNameMap();
						values.put(Images.Media.MIME_TYPE, fileNameMap.getContentTypeFor(path));
						act.getContentResolver().insert(Images.Media.EXTERNAL_CONTENT_URI, values);
						values = null; savedFile = null; fileNameMap = null; path = null;
					}
				});

		findViewById(R.id.button3).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Intent intent = new Intent(act, GalleryActivity.class);
						startActivityForResult(intent, 1);
					}
				});
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if (resultCode == RESULT_OK) {
			if (requestCode == 1) {
				String tmpPath = data.getStringExtra("path");
				if (tmpPath != null) {
					Uri uri = Uri.parse(tmpPath);
					iv.destroyDrawingCache();
					// iv.setImageURI(uri);
					try {
						Bitmap bm = Images.Media.getBitmap(getContentResolver(), uri);
						int width = bm.getWidth();
						int height = bm.getHeight();
						if (width > height) {
							Matrix matrix = new Matrix();
							matrix.postRotate(90);
							Bitmap rbm = Bitmap.createBitmap(bm, 0, 0, width, height, matrix, true);
							iv.setImageBitmap(rbm);
							rbm = null;
						} else {
							iv.setImageBitmap(bm);
						}
						bm = null;
					} catch (FileNotFoundException e1) {
						e1.printStackTrace();
					} catch (IOException e1) {
						e1.printStackTrace();
					}
					uri = null;
				}
			}
		}
	}

	public String nowdate() {
		java.util.Date date = new java.util.Date();
		String year = String.valueOf(date.getYear() + 1900);
		String month = int2code(date.getMonth() + 1);
		String day = int2code(date.getDate());
		String hour = int2code(date.getHours());
		String minute = int2code(date.getMinutes());
		String second = int2code(date.getSeconds());
		return year + month + day + hour + minute + second;
	}

	public String int2code(int val) {
		String str = "";
		if (val < 10) {
			str += String.valueOf("0" + val);
		} else {
			str += String.valueOf(val);
		}
		return str;
	}

}