package com.owl.sample;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.provider.ContactsContract.Data;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.CursorAdapter;
import android.widget.Filterable;
import android.widget.MultiAutoCompleteTextView;
import android.widget.TextView;

public class AutoCompleteTextViewActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		String[] optionLavala = getResources().getStringArray(
				R.array.dataArray1);
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_dropdown_item_1line, optionLavala);
		AutoCompleteTextView textView = (AutoCompleteTextView) findViewById(R.id.autoCompleteTextView1);
		textView.setAdapter(adapter);

		ContentResolver content = getContentResolver();
		Cursor cursor = content.query(Data.CONTENT_URI, ContactsProjection,
				null, null, Data.DISPLAY_NAME);
		ContactListAdapter adapterContact = new ContactListAdapter(this, cursor);

		MultiAutoCompleteTextView textViewMulti 
			= (MultiAutoCompleteTextView) findViewById(R.id.multiAutoCompleteTextView1);
		textViewMulti.setAdapter(adapterContact);
		textViewMulti
				.setTokenizer(new MultiAutoCompleteTextView.CommaTokenizer());
	}

	private static final String[] ContactsProjection = new String[] {
			ContactsContract.Contacts._ID,
			ContactsContract.Contacts.DISPLAY_NAME };

	public static class ContactListAdapter extends CursorAdapter implements	Filterable {

		private ContentResolver mContent;

		public ContactListAdapter(Context context, Cursor c) {
			super(context, c);
			mContent = context.getContentResolver();
		}

		@Override
		public View newView(Context context, Cursor cursor, ViewGroup parent) {
			final LayoutInflater inflater = LayoutInflater.from(context);
			final TextView view = (TextView) inflater.inflate(
					android.R.layout.simple_dropdown_item_1line, parent, false);
			view.setText(cursor.getString(1));
			return view;
		}

		@Override
		public void bindView(View view, Context context, Cursor cursor) {
			((TextView) view).setText(cursor.getString(1));
		}

		@Override
		public String convertToString(Cursor cursor) {
			return cursor.getString(1);
		}

		@Override
		public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
			if (getFilterQueryProvider() != null) {
				return getFilterQueryProvider().runQuery(constraint);
			}

			Cursor dataInfo = mContent.query(
					ContactsContract.Contacts.CONTENT_URI, ContactsProjection,
					"UPPER(" + ContactsContract.Contacts.DISPLAY_NAME
							+ ") GLOB ?", new String[] { constraint.toString()
							.toUpperCase()
							+ "*" }, ContactsContract.Contacts.DISPLAY_NAME);
			return dataInfo;

		}
	}

}