/*
* Copyright 2009 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
using System;
namespace com.google.zxing
{
	
	/// <summary> Callback which is invoked when a possible result point (significant
	/// point in the barcode image such as a corner) is found.
	/// 
	/// </summary>
	/// <seealso cref="DecodeHintType.NEED_RESULT_POINT_CALLBACK">
	/// </seealso>
	public interface ResultPointCallback
	{
		
		void  foundPossibleResultPoint(ResultPoint point);
	}
}